% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedOtherMethods.R
\docType{methods}
\name{addNodes,character-method}
\alias{addNodes,character-method}
\alias{addNodes}
\title{addNodes}
\usage{
\S4method{addNodes}{character}(nodes, ...)
}
\arguments{
\item{nodes}{A vector with node names.}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Add nodes to an active RedeR session.
}
\description{
Add nodes to an active RedeR application.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create a vector with node names
nodes <- c("n1", "n2", "n3", "n4", "n5")

\donttest{
# Start the RedeR interface and add nodes
startRedeR()
addNodes(nodes)
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
