% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedWrappers.R
\name{addLegendToRedeR}
\alias{addLegendToRedeR}
\title{Adding graph legends to the RedeR app}
\usage{
addLegendToRedeR(
  x,
  type = "nodecolor",
  position = "default",
  orientation = "default",
  title = type,
  font.size = 12,
  stretch = 0,
  ...
)
}
\arguments{
\item{x}{A vector with legend values (see examples).}

\item{type}{A legend type. Options: 'nodecolor', 'edgecolor', 'nodesize',
'edgewidth', 'nodeshape', 'edgetype'.}

\item{position}{Position of the legend in app panel. Options:
'default', 'topleft', 'topright', 'bottomleft', 'bottomright', and 'remove'.
Use 'default' to place the legend on a predefined slot, or 'remove' to
delete the legend type.}

\item{orientation}{The orientation of the legend. Options: 'default',
'vertical', 'horizontal'. Use 'default' to automatically set the
orientation for the legend type.}

\item{title}{A string for legend title.}

\item{font.size}{Font size (unit in points).}

\item{stretch}{A scaling factor to adjust the legend box (between 0 and 1).}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Send legend objects to RedeR app.
}
\description{
Methods to display legends in the RedeR app.
}
\examples{

# Load RedeR
library(RedeR)

\donttest{
# Start the RedeR interface
startRedeR()

# Adding node and edge color legends
cols <- colorRampPalette(colors = c("red", "blue"))(14)
names(cols) <- 1:length(cols)
addLegendToRedeR(x = cols, type = "nodecolor")
addLegendToRedeR(x = cols, type = "edgecolor", stretch = 0.1)

# Adding node size legend
nsize <- c(10, 20, 30, 40, 50)
addLegendToRedeR(x = nsize, type = "nodesize")

# Adding edge width legend
esize <- c(1:10)
addLegendToRedeR(x = esize, type = "edgewidth")

# Adding node shape legend
shape <- c("ELLIPSE","RECTANGLE","ROUNDED_RECTANGLE","TRIANGLE","DIAMOND")
names(shape) <- shape
addLegendToRedeR(x = shape, type = "nodeshape")

# Adding edge linetype legend
ltype <- c("SOLID", "DOTTED", "DASHED", "LONG_DASH")
names(ltype) <- ltype
addLegendToRedeR(x = ltype, type = "edgetype")
}

}
\seealso{
\code{\link{startRedeR}}, \code{\link{addGraphToRedeR}}
}
\author{
Sysbiolab.
}
