/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public class RedPreferences {
    private final Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private final String userDir = System.getProperty("user.dir");

    RedPreferences() {
    }

    public void setUserDir(int dir) {
        this.prefs.putInt("userDir", dir);
    }

    public void setToolBarFileVisible(boolean tb) {
        this.prefs.putBoolean("tBarFileVisible", tb);
    }

    public void setToolBarSelectVisible(boolean tb) {
        this.prefs.putBoolean("tBarSelectVisible", tb);
    }

    public void setToolBarEditVisible(boolean tb) {
        this.prefs.putBoolean("tBarEditVisible", tb);
    }

    public void setToolBarLayoutVisible(boolean tb) {
        this.prefs.putBoolean("tBarLayoutVisible", tb);
    }

    public void setRigthTabsVisible(boolean tb) {
        this.prefs.putBoolean("rigthTabsExpanded", tb);
    }

    public void setMainPaneExpanded(boolean tb) {
        this.prefs.putBoolean("mainPaneExpanded", tb);
    }

    public String getUserDir() {
        return this.prefs.get("userDir", this.userDir);
    }

    public boolean isToolBarFileVisible() {
        return this.prefs.getBoolean("tBarFileVisible", true);
    }

    public boolean isToolBarSelectVisible() {
        return this.prefs.getBoolean("tBarSelectVisible", true);
    }

    public boolean isToolBarEditVisible() {
        return this.prefs.getBoolean("tBarEditVisible", true);
    }

    public boolean isToolBarLayoutVisible() {
        return this.prefs.getBoolean("tBarLayoutVisible", true);
    }

    public boolean isRigthTabsExpanded() {
        return this.prefs.getBoolean("rigthTabsExpanded", true);
    }

    public boolean isMainPaneExpanded() {
        return this.prefs.getBoolean("mainPaneExpanded", true);
    }

    public final String getOsType() {
        String osType = System.getProperty("os.name");
        Pattern ptWin = Pattern.compile("win", 2);
        Pattern ptMac = Pattern.compile("mac", 2);
        Pattern ptLin = Pattern.compile("linux", 2);
        if (ptWin.matcher(osType).find()) {
            return "win";
        }
        if (ptMac.matcher(osType).find()) {
            return "mac";
        }
        if (ptLin.matcher(osType).find()) {
            return "linux";
        }
        return "unknown";
    }

    public final float getJavaVersion() {
        float version = Float.parseFloat(System.getProperty("java.specification.version"));
        if (version == 1.5f) {
            version = 5.0f;
        }
        if (version == 1.6f) {
            version = 6.0f;
        }
        if (version == 1.7f) {
            version = 7.0f;
        }
        if (version == 1.8f) {
            version = 8.0f;
        }
        return version;
    }
}

