/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Ascii85OutputStream
extends FilterOutputStream {
    private int width = 72;
    private int pos;
    private int tuple;
    private int count;
    private boolean encoding;
    private boolean useSpaceCompression;

    public Ascii85OutputStream(OutputStream out) {
        super(out);
    }

    public Ascii85OutputStream(OutputStream out, boolean useSpaceCompression) {
        this(out);
        this.useSpaceCompression = useSpaceCompression;
    }

    public Ascii85OutputStream(OutputStream out, int width, boolean useSpaceCompression) {
        this(out);
        this.width = width;
        this.useSpaceCompression = useSpaceCompression;
    }

    private void startEncoding() throws IOException {
        this.encoding = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.encoding) {
            this.startEncoding();
        }
        switch (this.count++) {
            case 0: {
                this.tuple |= (b & 0xFF) << 24;
                break;
            }
            case 1: {
                this.tuple |= (b & 0xFF) << 16;
                break;
            }
            case 2: {
                this.tuple |= (b & 0xFF) << 8;
                break;
            }
            case 3: {
                this.tuple |= b & 0xFF;
                if (this.tuple == 0) {
                    this.out.write(122);
                    if (this.pos++ >= this.width) {
                        this.pos = 0;
                        this.out.write(13);
                        this.out.write(10);
                    }
                } else if (this.useSpaceCompression && this.tuple == 0x20202020) {
                    this.out.write(121);
                    if (this.pos++ >= this.width) {
                        this.pos = 0;
                        this.out.write(13);
                        this.out.write(10);
                    }
                } else {
                    this.encode(this.tuple, this.count);
                }
                this.tuple = 0;
                this.count = 0;
            }
        }
    }

    public void writeUnencoded(int b) throws IOException {
        super.write(b);
    }

    public void writeUnencoded(byte[] b) throws IOException {
        this.writeUnencoded(b, 0, b.length);
    }

    public void writeUnencoded(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.writeUnencoded(b[off + i]);
        }
    }

    private void encode(int tuple, int count) throws IOException {
        int i = 5;
        byte[] buf = new byte[5];
        int bufPos = 0;
        long longTuple = (long)tuple & 0xFFFFFFFFL;
        do {
            int n = bufPos;
            bufPos = (short)(bufPos + 1);
            buf[n] = (byte)(longTuple % 85L);
            longTuple /= 85L;
        } while (--i > 0);
        i = count;
        do {
            bufPos = (short)(bufPos - 1);
            this.out.write(buf[bufPos] + 33);
            if (this.pos++ < this.width) continue;
            this.pos = 0;
            this.out.write(13);
            this.out.write(10);
        } while (i-- > 0);
    }

    @Override
    public void flush() throws IOException {
        if (this.encoding) {
            if (this.count > 0) {
                this.encode(this.tuple, this.count);
            }
            if (this.pos + 2 > this.width) {
                this.out.write(13);
                this.out.write(10);
            }
            this.out.write(126);
            this.out.write(62);
            this.out.write(13);
            this.out.write(10);
            this.encoding = false;
            this.count = 0;
            this.tuple = 0;
        }
        super.flush();
    }
}

