/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.util.ReflectionUtil;
import org.apache.xmlrpc.webserver.XmlRpcServletServer;

public class XmlRpcServlet
extends HttpServlet {
    private static final long serialVersionUID = 2348768267234L;
    private static final Log log = LogFactory.getLog(class$org$apache$xmlrpc$webserver$XmlRpcServlet == null ? (class$org$apache$xmlrpc$webserver$XmlRpcServlet = XmlRpcServlet.class$("org.apache.xmlrpc.webserver.XmlRpcServlet")) : class$org$apache$xmlrpc$webserver$XmlRpcServlet);
    private XmlRpcServletServer server;
    private AbstractReflectiveHandlerMapping.AuthenticationHandler authenticationHandler;
    private RequestProcessorFactoryFactory requestProcessorFactoryFactory;
    private TypeConverterFactory typeConverterFactory;
    static /* synthetic */ Class class$org$apache$xmlrpc$webserver$XmlRpcServlet;

    public XmlRpcServletServer getXmlRpcServletServer() {
        return this.server;
    }

    private void handleInitParameters(ServletConfig pConfig) throws ServletException {
        Enumeration en = pConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = pConfig.getInitParameter(name);
            try {
                if (ReflectionUtil.setProperty((Object)this, name, value) || ReflectionUtil.setProperty(this.server, name, value) || ReflectionUtil.setProperty(this.server.getConfig(), name, value)) continue;
                throw new ServletException("Unknown init parameter " + name);
            }
            catch (IllegalAccessException e) {
                throw new ServletException("Illegal access to instance of " + this.server.getClass().getName() + " while setting property " + name + ": " + e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw new ServletException("Failed to invoke setter for property " + name + " on instance of " + this.server.getClass().getName() + ": " + t.getMessage(), t);
            }
        }
    }

    public void init(ServletConfig pConfig) throws ServletException {
        super.init(pConfig);
        try {
            this.server = this.newXmlRpcServer(pConfig);
            this.handleInitParameters(pConfig);
            this.server.setHandlerMapping(this.newXmlRpcHandlerMapping());
        }
        catch (XmlRpcException e) {
            try {
                this.log("Failed to create XmlRpcServer: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ServletException((Throwable)e);
        }
    }

    public void setAuthenticationHandler(AbstractReflectiveHandlerMapping.AuthenticationHandler pHandler) {
        this.authenticationHandler = pHandler;
    }

    public AbstractReflectiveHandlerMapping.AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public void setRequestProcessorFactoryFactory(RequestProcessorFactoryFactory pFactory) {
        this.requestProcessorFactoryFactory = pFactory;
    }

    public RequestProcessorFactoryFactory getRequestProcessorFactoryFactory() {
        return this.requestProcessorFactoryFactory;
    }

    public void setTypeConverterFactory(TypeConverterFactory pFactory) {
        this.typeConverterFactory = pFactory;
    }

    public TypeConverterFactory getTypeConverterFactory() {
        return this.typeConverterFactory;
    }

    protected XmlRpcServletServer newXmlRpcServer(ServletConfig pConfig) throws XmlRpcException {
        return new XmlRpcServletServer();
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        URL url = (class$org$apache$xmlrpc$webserver$XmlRpcServlet == null ? (class$org$apache$xmlrpc$webserver$XmlRpcServlet = XmlRpcServlet.class$("org.apache.xmlrpc.webserver.XmlRpcServlet")) : class$org$apache$xmlrpc$webserver$XmlRpcServlet).getResource("XmlRpcServlet.properties");
        if (url == null) {
            throw new XmlRpcException("Failed to locate resource XmlRpcServlet.properties");
        }
        try {
            return this.newPropertyHandlerMapping(url);
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to load resource " + url + ": " + e.getMessage(), e);
        }
    }

    protected PropertyHandlerMapping newPropertyHandlerMapping(URL url) throws IOException, XmlRpcException {
        PropertyHandlerMapping mapping = new PropertyHandlerMapping();
        mapping.setAuthenticationHandler(this.authenticationHandler);
        if (this.requestProcessorFactoryFactory != null) {
            mapping.setRequestProcessorFactoryFactory(this.requestProcessorFactoryFactory);
        }
        if (this.typeConverterFactory != null) {
            mapping.setTypeConverterFactory(this.typeConverterFactory);
        } else {
            mapping.setTypeConverterFactory(this.server.getTypeConverterFactory());
        }
        mapping.setVoidMethodEnabled(this.server.getConfig().isEnabledForExtensions());
        mapping.load(Thread.currentThread().getContextClassLoader(), url);
        return mapping;
    }

    public void doPost(HttpServletRequest pRequest, HttpServletResponse pResponse) throws IOException, ServletException {
        this.server.execute(pRequest, pResponse);
    }

    public void log(String pMessage, Throwable pThrowable) {
        this.server.getErrorLogger().log(pMessage, pThrowable);
    }

    public void log(String pMessage) {
        log.info(pMessage);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

