% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{perform_reactome_analysis}
\alias{perform_reactome_analysis}
\title{Perform a Reactome Analaysis}
\usage{
perform_reactome_analysis(
  request,
  verbose = TRUE,
  compress = TRUE,
  reactome_url = NULL
)
}
\arguments{
\item{request}{\code{\link{ReactomeAnalysisRequest}} to submit.}

\item{verbose}{logical. If \code{FALSE} status messages are not printed to the console.}

\item{compress}{logical. If \code{TRUE} (default) the request data is compressed before submitting it to the ReactomeGSA API.
This is the generally recommended way and should only be disabled for debugging purposes.}

\item{reactome_url}{URL of the Reactome API Server. Overwrites the URL set in the 'reactome_gsa.url' option.
Specific ports can be set using the standard URL specification (for example http://your.service:1234)}
}
\value{
The analysis' result
}
\description{
This function wraps all steps required to perform
an Analysis using the Reactome Analysis Service. It submits
the passed \code{\link{ReactomeAnalysisRequest}} object to the
Reactome Analysis Service API, checks the submitted analysis'
status and returns the result once the analysis is complete.
}
\examples{
# create a request using Camera as an analysis
library(ReactomeGSA.data)
data(griss_melanoma_proteomics)

my_request <- ReactomeAnalysisRequest(method = "Camera")

# set maximum missing values to 0.5 and do not create any reactome visualizations
my_request <- set_parameters(request = my_request,
                             max_missing_values = 0.5,
                             create_reactome_visualization = FALSE)

# add the dataset
my_request <- add_dataset(request = my_request,
                          expression_values = griss_melanoma_proteomics,
                          name = "Proteomics",
                          type = "proteomics_int",
                          comparison_factor = "condition",
                          comparison_group_1 = "MOCK",
                          comparison_group_2 = "MCM",
                          additional_factors = c("cell.type", "patient.id"))

# perform the analysis
my_result <- perform_reactome_analysis(request = my_request, verbose = FALSE)
}
