% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getData}
\alias{getData}
\title{getData}
\usage{
getData(
  rcp,
  outdir,
  prefix = NULL,
  notes = c(),
  conda = FALSE,
  BPPARAM = NULL,
  ...
)
}
\arguments{
\item{rcp}{the data recipe in \code{cwlProcess} S4 class.}

\item{outdir}{Character string specifying the directory to store
the output files. Will automatically create if not exist or
provided.}

\item{prefix}{Character string specifying the file name of the
annotation files (.yml, .cwl, .sh, .md5).}

\item{notes}{User assigned notes/keywords to annotate the data and
be used for keywords matching in \code{dataSearch(keywords = )}.}

\item{conda}{Whether to use conda to install required software when
evaluating the data recipe as a CWL workflow. Default is FALSE.}

\item{BPPARAM}{The options for \code{BiocParallel::bpparam}.}

\item{...}{Arguments to be passed into \code{Rcwl:runCWL()}.}
}
\value{
The data files and 4 meta files: \code{.cwl}: The cwl script
that was internally run to get the data; \code{.yml}: the input
parameter values for the data recipe and user specified data
annotation notes, versions etc; \code{.sh}: The script for data
processing; \code{.md}: checksum file to verify the integrity of
generated data files.
}
\description{
Evaluation of data recipes to generate curated dataset of interest.
}
\examples{
\dontrun{
library(Rcwl)
outdir <- file.path(tempdir(), "SharedData")

## Example 1
echo_out <- recipeLoad("echo_out")
Rcwl::inputs(echo_out)
echo_out$input <- "Hello World!"
echo_out$outfile <- "outfile"
res <- getData(echo_out,
               outdir = outdir,
               notes = c("echo", "hello", "world", "txt"),
               showLog = TRUE)

# Example 2
ensembl_liftover <- recipeLoad("ensembl_liftover")
Rcwl::inputs(ensembl_liftover)
ensembl_liftover$species <- "human"
ensembl_liftover$from <- "GRCh37"
ensembl_liftover$to <- "GRCh38"

res <- getData(ensembl_liftover,
        outdir = outdir, 
        notes = c("ensembl", "liftover", "human", "GRCh37", "GRCh38"),
        showLog = TRUE)
dir(outdir)
}
}
