% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMolecule.R
\name{getMolecule}
\alias{getMolecule}
\alias{getMass}
\alias{getMonoisotopic}
\alias{getIsotope}
\alias{getFormula}
\alias{getScore}
\alias{getValid}
\title{Calculate mass and isotope information for a molecule given as sum formula}
\usage{
getMolecule(formula, elements = NULL, z = 0, maxisotopes = 10)

getMass(molecule)

getMonoisotopic(molecule)

getIsotope(molecule, index)

getFormula(molecule)

getScore(molecule)

getValid(molecule)
}
\arguments{
\item{formula}{Sum formula.}

\item{elements}{List of allowed chemical elements, defaults to full periodic system of elements. See \code{\link{initializeElements}}.}

\item{z}{Charge z of molecule for exact mass calculation.}

\item{maxisotopes}{Maximum number of isotopes shown for the resulting molecule.}

\item{molecule}{An initialized molecule as returned by getMolecule() or the decomposeMass() and decomposeIsotope() functions.}

\item{index}{Return the n-th isotope mass/abundance pair(s) of the molecule}
}
\value{
A list containing the elements `formula` (repeated sum formula), 
    `mass` exact mass of molecule, `score` probability, for given molecules a 
    dummy value which is always 1.0, `valid` result of neutrogen rule check, 
    `isotopes` a list of isotope masses and abundances.
}
\description{
Parse the sum formula and calculate the theoretical exact mass 
    and the isotope distribution for an approximate MS resolution of 20,000 
    (i.e. not providing the isotopic fine structure).
}
\details{
\code{getMolecule()} will parse the sum formula and calculate the 
    exact mass and the isotope distribution.
    The exact mass is the mass of the most abundant isotope and is not 
    identical with the monoisotopic mass. The latter can be extracted using 
    the function `getMonoisotopic()`. This function can also be supplied with 
    a vector of chemical formulas directly (in case that the isotopic 
    distribution is of no interest).
    Since of version 1-65-3, if a charge is specified, the exact mass of the 
    molecule will be reduced or increased by n-times the electron mass 
    (depending on the sign). Also, isotopic masses will additionally be 
    divided by the charge specified to reflect what would be measured in HR-MS.
}
\examples{
# Ethanol
getMolecule("C2H6O")

}
\references{
For a description of the underlying IMS see citation("Rdisop")
}
\author{
Steffen Neumann <sneumann@IPB-Halle.DE>
}
