% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMolecules.R
\name{addMolecules}
\alias{addMolecules}
\alias{subMolecules}
\title{Add/subtract sum formulas}
\usage{
addMolecules(formula1, formula2, elements = NULL, maxisotopes = 10)

subMolecules(formula1, formula2, elements = NULL, maxisotopes = 10)
}
\arguments{
\item{formula1}{Sum formula (can be a vector).}

\item{formula2}{Sum formula.}

\item{elements}{List of allowed chemical elements, defaults to full periodic system of elements. See \code{\link{initializeElements}}.}

\item{maxisotopes}{Maximum number of isotopes shown in the resulting molecules.}
}
\value{
The input vector formula1 will be converted into molecule objects similar
    to function \code{\link{getMolecule}}. However, the results will be amended 
    or reduced by formula2.
}
\description{
Simple arithmetic modifications of sum formulas.
}
\details{
`addMolecules` adds the second argument to the first. `subMolecules`
   subtracts the second argument from the first. This can be useful to revert
   e.g. adduct/fragment formation found in ESI mass spectrometry, or to 
   mimic simple chemical reactions. No chemical checks are performed.
}
\examples{
# Remove the proton-adduct from Ethanol
subMolecules("C2H7O", "H")

}
