% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestamp.R
\name{cl_timestamp}
\alias{cl_timestamp}
\alias{cl_timestamp_layer}
\alias{cl_timestamp_label}
\title{Functions to add time stamps to collectl output}
\usage{
cl_timestamp(proc, step)

cl_timestamp_layer(arg)

cl_timestamp_label(arg, tz = "EST")
}
\arguments{
\item{proc}{an entity inheriting from "Rcollectl_process" S3 class}

\item{step}{character(1) name of step within a workflow}

\item{arg}{proc (an entity inheriting from "Rcollectl_process" S3 class) or path to collectl output}

\item{tz}{character(1) time zone code}
}
\value{
\code{cl_timestamp()} returns a tab delimited text file

\code{cl_timestamp_layer()} and \code{cl_timestamp_label()} return objects that can be combined with ggplot.
}
\description{
Functions to add time stamps to collectl output
}
\examples{
id <- cl_start() 
Sys.sleep(2)
cl_timestamp(id, "step1")
Sys.sleep(2)
Sys.sleep(2)
cl_timestamp(id, "step2")
Sys.sleep(2)
Sys.sleep(2)
cl_timestamp(id, "step3")
Sys.sleep(2)
cl_stop(id)
path <- cl_result_path(id)
plot_usage(cl_parse(path)) +
  cl_timestamp_layer(path) +
  cl_timestamp_label(path) +
  ggplot2::theme(axis.text.x = ggplot2::element_text(angle = 90, vjust = 0.5, hjust=1))
}
