% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl_parse.R
\name{cl_parse}
\alias{cl_parse}
\title{parse a collectl output -- could be conditional on discovered call}
\usage{
cl_parse(path, tz = "EST", rescale_mem = TRUE)
}
\arguments{
\item{path}{character(1) path to (possibly gzipped) collectl output}

\item{tz}{character(1) POSIXct time zone code, defaults to "EST"}

\item{rescale_mem}{logical(1) if TRUE, divide reported MEM_Used by 1000}
}
\value{
a data.frame
}
\description{
parse a collectl output -- could be conditional on discovered call
}
\note{
A lubridate datetime is added as a column.  The test file \code{demo_1123.tab.gz} is
a collectl-generated report for a session ranging over 10 minutes, analyzing RNA-seq data
on a multicore machine.
}
\examples{
lk = cl_parse(system.file("demotab/demo_1123.tab.gz", package="Rcollectl"))
head(lk)
}
