% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_aucScores.R
\docType{class}
\name{aucScores-class}
\alias{aucScores-class}
\alias{aucScores}
\alias{getAUC}
\alias{show,aucScores-method}
\alias{getAUC,aucScores-method}
\title{Class to store the AUC scores for RcisTarget.}
\usage{
\S4method{show}{aucScores}(object)

\S4method{getAUC}{aucScores}(object)
}
\arguments{
\item{object}{Results from \code{calcAUC}.}
}
\value{
\itemize{
\item show: Prints a summary of the object
\item getAUC: Returns the matrix containing the AUC scores
}
}
\description{
Contains the AUC scores for each gene- or region-set.
They can be accessed through \code{getAUC()} and the regular methods
(i.e. nrow, rownames... ) available for SummarizedExperiment objects.
}
\examples{
##################################################
# Setup & previous steps in the workflow:

#### Gene sets
# As example, the package includes an Hypoxia gene set:
txtFile <- paste(file.path(system.file('examples', package='RcisTarget')),
                 "hypoxiaGeneSet.txt", sep="/")
geneLists <- list(hypoxia=read.table(txtFile, stringsAsFactors=FALSE)[,1])

#### Databases
## Motif rankings: Select according to organism and distance around TSS
## (See the vignette for URLs to download)
# motifRankings <- importRankings("hg19-500bp-upstream-7species.mc9nr.feather")

## For this example we will use a SUBSET of the ranking/motif databases:
library(RcisTarget.hg19.motifDBs.cisbpOnly.500bp)
data(hg19_500bpUpstream_motifRanking_cispbOnly)
motifRankings <- hg19_500bpUpstream_motifRanking_cispbOnly

## Motif - TF annotation:
data(motifAnnotations_hgnc_v9) # human TFs (for motif collection 9)
motifAnnotation <- motifAnnotations_hgnc_v9

### Run RcisTarget
# Step 1. Calculate AUC
motifs_AUC <- calcAUC(geneLists, motifRankings)

##################################################

#Exploring the output:
motifs_AUC

class(motifs_AUC)

# Extracting the AUC matrix:
getAUC(motifs_AUC)[,1:5]

# Subsetting and regular manipulation methods are also available:
motifs_AUC[1,]
motifs_AUC[,3:4]

dim(motifs_AUC)
nrow(motifs_AUC)
ncol(motifs_AUC)
colnames(motifs_AUC)
rownames(motifs_AUC)
}
