#' Documentation for the data

#' @rdname dbRegionsLoc
#' @name dbRegionsLoc
#' @aliases dbRegionsLoc_hg19_v9 dbRegionsLoc_mm9_v9
#' @title Genomic location for the database regions
#' @description 
#' \itemize{
#' \item{\bold{dbRegionsLoc_hg19_v9}: }{Contains the location for \bold{HUMAN} regions 
#'   in the database \bold{hg19-regions-9species.all_regions.mc9nr} (hg19,refseq_r45, motif collection v9).
#'   
#'   Source: \emph{hg19__refseq_r45__ClusteredUniformDHS_all_merge_cleaned2_features_rm-insul_rm-exons2_extend.regionid-location.bed}}
#'   
#' \item{\bold{dbRegionsLoc_mm9_v9}: }{Contains the location for \bold{MOUSE} regions 
#'   in the database \bold{mm9-regions-9species.all_regions.mc9nr} (mm9, refseq_r70, motif collection v9).
#' 
#' Source: \emph{mm9__refseq_r70__regulatory_regions.regionid-location.bed}}
#' 
#'\item{For \bold{drosophila}, use the function \code{\link{getDbRegionsLoc}}}
#' }
#' @docType data
#' @seealso https://resources.aertslab.org/cistarget
#' @keywords datasets
NULL