% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xa2multi.R
\name{xa2multi}
\alias{xa2multi}
\title{Unpack multiple alignments stored in BWA output}
\usage{
xa2multi(input_sam_file, output_sam_file)
}
\arguments{
\item{input_sam_file}{String specifying path of the input SAM file.}

\item{output_sam_file}{String specifying path of the output SAM file.}
}
\value{
Returns NULL invisibly. SAM file with multiple alignments
   is produced as a side effect.
}
\description{
Unpack multiple alignments stored in BWA output
}
\details{
Each row in the SAM file produced by \code{\link{bwa_aln}}
    corresponds to the best alignment hit for a given input query
    sequence. Other alignments (secondary alignments, or other loci
    in case of multiple alignments) are stored in the XA tag.

    \code{xa2multi} conveniently extracts the alignments from the XA
    tags and represent them as additional rows in the SAM format.
}
\examples{
# Creating index:
dir <- tempdir()
fasta <- system.file(package="Rbwa",
                     "fasta/chr12.fa")
fastq <- system.file(package="Rbwa",
                     "fastq/sequences.fastq")
index_prefix <- file.path(dir,"chr12")
bwa_build_index(fasta, index_prefix=index_prefix)

# Creating alignments:
bwa_aln(index_prefix=index_prefix,
        fastq_files=fastq,
        sai_files=file.path(dir, "output.sai"))

# Generating SAM file:
bwa_sam(index_prefix=index_prefix,
        fastq_files=fastq,
        sai_files=file.path(dir, "output.sai"),
        sam_file=file.path(dir, "output.sam"))

# Generating multiple alignments:
xa2multi(input_sam_file=file.path(dir, "output.sam"),
         output_sam_file=file.path(dir, "output.multi.sam"))

#' Reading in: 
aln <- readLines(file.path(dir, "output.multi.sam"))
aln

}
\author{
Jean-Philippe Fortin
}
