% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkUtils.R
\name{checkIndexType}
\alias{checkIndexType}
\title{Determine bowtie2 index type}
\usage{
checkIndexType(filePath)
}
\arguments{
\item{filePath}{\code{Character} scalar. The path where bowtie2 index files 
are located. Include the basename of the index files at the end of the path
(i.e. path_to_index_dir/index_basename). Do not include the bowtie2 index file 
extension (.bt2 or .bt2l).}
}
\value{
\code{Character} scalar. Returns either "SMALL" if the .bt2 file is found,
"LARGE" if the .bt2l file is found, or "ERROR" if neither the .bt2 nor .bt2l file 
is found.
}
\description{
This is an internal function that is not meant to be used outside
of the package. It determines whether the given index library comprises of 
small indexes (.bt2) or large indexes (.bt2l).
}
\details{
The function first tries to determine whether 
path_to_index_dir/index_basename.1.bt2 exists and if it doesn't exist then it
tries to determine whether path_to_index_dir/index_basename.1.bt2l exists. 
If neither of those files exist then there is an issue with the index files 
that must be addressed.
}
