% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rbec_summarise.R
\name{Contam_detect}
\alias{Contam_detect}
\title{Reference-based error correction of amplicon sequencing data}
\usage{
Contam_detect(log_file, outdir, outlier_constant=1.5)
}
\arguments{
\item{log_file}{the file contains a list of log files of each sample outputted with Rbec function}

\item{outdir}{output directory}

\item{outlier_constant}{the multiplier of variance to define the outlier}
}
\value{
Returns a plot showing the distribution of percentage of corrected reads across the whole sample set and a summary file recording which samples might be contaminated
}
\description{
This function is designed for predicting the contaminated samples
}
\details{
Ruben Garrido-Oter's group, Plant-Microbe interaction, Max Planck Institute for Plant Breeding Research
}
\examples{
#log_file <- system.file("extdata", "rbec_test.list", package = "Rbec")
log_path <- list.files(paste(path.package("Rbec"), 
	"extdata/contamination_test", sep="/"), 
	recursive=TRUE, full.names=TRUE)
log_file <- tempfile()
writeLines(log_path, log_file)
Contam_detect(log_file, tempdir())

}
\author{
Pengfan Zhang
}
