# CZI EOSS6: Zarr support for R & Bioconductor

**Status**: Not funded

## 1. Proposal Title: 

Zarr support for R & Bioconductor

## 2. Previous Funding: 

No

## 3. Proposal Purpose: 

To bring comprehensive support for Zarr arrays to R & Bioconductor

## 4. Amount Requested: 

$301,944.80

## 5. Proposal Summary: 

As the volume and richness of biomedical data and analysis tools continues to grow, there is a need to adopt storage formats that are performant across a variety of storage modalities and can be readily accessed from multiple programming languages. A prominent example is Zarr, which is seeing rapid adoption across a variety of biomedical applications, including single-cell ‘omics and bioimaging. The Rarr package provides the first feature rich interface to Zarr in the R language.  Here, we propose to make essential enhancements and updates to Rarr to deliver comprehensive support for Zarr to R & Bioconductor.

Arranging N-dimensional array data in individually referenceable and compressible chunks, Zarr’s design provides a flexible and scalable storage solution, whether the array is stored in memory, on local disk, or a cloud object store.  Version 3 of the Zarr specification (Zarr v3) was recently ratified by the Zarr implementation council.  This version brings significant modifications, including changes to supported data types to create a language agnostic format, and additional options for how data chunks are stored that will improve the performance across different storage technologies.  However Zarr v3 is backwards incompatible with previous versions, requiring that existing implementations, such as Rarr, must be updated to support the new features and requiring significant changes to the existing software.

Reflecting this, we propose to overhaul the Rarr codebase to bring Zarr v3 into R. This revision also provides the opportunity to clearly decouple the array access operations from the underlying storage implementation, improving support for different storage technologies and easing future maintenance.  We will also take the opportunity to implement the parallel processing options available in R to improve performance, something Zarr is readily amenable to. 

Although the current version of Rarr provides a comprehensive implementation of the Zarr v2 specification, it does not, on its own, provide an easy route for a data analyst to switch between in-memory and Zarr-backed arrays.  This is a common challenge, and in R/Bioconductor there are many examples of containers that mimic the standard R array API, either in memory (dgGMatrix, RleArray) or on disk (HDF5Array, tiledb_array). We propose to extend Rarr to provide such an interface, enabling R programmers to transition seamlessly between Zarr-backed arrays and other array types.  This will also allow us to extend the utility of Zarr arrays in R by using delayed operations via the DelayedArray package, which enables one to perform common operations efficiently without repeated I/O operations.

While Zarr is a format designed to contain generic multi-dimensional data, its ability to store a variety of data types in a hierarchical structure, alongside relevant metadata, means it has been adopted as the cornerstone of more specific data structures.  One example is OME-Zarr, a bioimaging container for multiple images and their derived data.  We intend to create a new Bioconductor package for working with data in the OME-Zarr format, leveraging Rarr for the generic I/O operations and using the R S4 class system to represent the structure & metadata inherent to OME-Zarr.

## 6. Work Plan: 

In order  to achieve our stated goals, we request support for a new software engineer to drive new developments and maintain the existing infrastructure.  

In a first step, we will provide a more generic, array-like, interface to Zarr arrays.  This will enable other Bioconductor tools that want to use Zarr arrays to continue their own development with the assumption of a known API, or to use Zarr arrays as a drop-in replacement for existing array datatypes.  We will achieve this by adopting the DelayedArray framework, which can be used by R & Bioconductor packages to perform common array operations with on-disk objects without loading the object into memory.  We will develop a backend within this framework to interface with Zarr arrays.

We will begin by creating a new S4 class, ZarrArraySeed.  This class is principally a light-weight wrapper containing the path to a Zarr array, either on disk or in a cloud object store.  Methods defining common operations, such as returning the array dimensions or extracting subsets of data then need to be defined. Here we can use the functionality already provided by Rarr to rapidly implement this.  Finally we will create a second new class, ZarrArray, which inherits from the already defined DelayedArray class and incorporates the ZarrArraySeed into the “seed” slot.  This inheritance will then immediately provide common array operations such as subsetting, and access to the efficient “block processing” provided by DelayedArray.

In addition to providing useful downstream tools to R & Bioconductor users, Rarr must also accommodate upstream developments in Zarr.  Most pressing of these is the newly ratified Zarr V3 specification.  We have already determined that restructuring the existing Rarr codebase will be required to implement the new specification, and reduce the maintenance burden going forward.  We will begin by making Rarr more modular using S4 classes to represent the various possible types of “array stores”.  These will encapsulate the existing on-disk and object store functionality, as well as bring a new in-memory representation based on R lists. The functions to read and write Zarr arrays will then be updated to work with this new representation of the array store.  This will include implementing the new Zarr codecs e.g. the transpose codec for mapping between row- and column-major array representations (crucial for cross language portability) and the sharding codec that allows a hierarchy of array chunks, adding the functionality to write to S3 buckets, and implementing multithreaded I/O operations.

Once we have improved support for Zarr as a generic array format we will focus on creating software infrastructure specifically for OME-Zarr image format.  This work will lead to a separate R package that depends on Rarr.  The core of this package will be another new S4 class, OME-Zarr, with slots for a hierarchy of Zarr images and the associated OME-Zarr metadata.  The core data in OME-Zarr is a set of multiscale images, each of which is a Zarr array, and will be represented in R as a list of ZarrArray objects.  The metadata consists of JSON files as well as one or more optional “labels” stored as a secondary set of Zarr arrays that correspond to the primary multiscale images.  We will provide utilities to both read existing OME-Zarr images as well as construct them from existing images. We will make use of existing R tools where possible, e.g. the EBImage package provides tools to downsample an image to generate a hierarchy of scaled images as well as segmentation for applying labels.

Based on our prior experience we are aware that as the user base of a software project grows there is an increasing need to dedicate time to maintenance and user support, in addition to new development work.  We are committed to creating useful user focused documentation in the form of R package vignettes as well as monitoring support channels such as the Bioconductor Support Forum and GitHub issues.

Mike Smith is the original author of Rarr, alongside multiple other Bioconductor packages, and will provide direct supervision of the project.  As a founding member of Bioconductor Wolfgang Huber will provide mentorship and oversight within the wider project goals.  Christian Tischer will provide guidance on the image data aspects of the project, specifically the support for OME-Zarr where he is a contributor to the specification standard and has implemented Java code to work with OME-Zarr. The recruited developer will also attend Zarr meetings e.g. bi-weekly Zarr Office Hours and ZarrCon to meet other developers and discuss common issues, strategies, and goals.

## 7. Milestones and Deliverables: 

### Timeline:

**June 2024** - Recruitment of a software engineer.  

Initial onboarding to familiarise the engineer with the Zarr specification and use cases, the existing Rarr codebase, and the wider Bioconductor ecosystem. After this onboarding, the first priority will be to prototype and implement the ZarrArray class and integration with the DelatedArray framework.  Efforts will be made to keep modification to the existing Rarr functionality to a minimum during this time, whilst also considering the future changes proposed in the workplan.

**November 2024** - Bioconductor 3.20.  ZarrArray class and array-style interface made widely available to users.

The next focus will be on refactoring Rarr into a more modular structure.  These changes will bring alignment with Zarr v3, as well as adding additional functionality such as writing to S3 storage. This may be a breaking release with changes to the public API, and hence necessitate a version increase to 2.0.  It will be accompanied by updated package documentation describing the new features and demonstrating their use.

**April 2025** - Bioconductor 3.21.  Release of Rarr 2.0 with full support for Zarr v3.

Attention will now turn to creating the OME-Zarr package. Time will be spent by the developer learning about this specific data format, and prototyping with datasets provided by biomedical imaging collaborators at EMBL. An evaluation of packages that provide relevant image processing tools will be conducted to reuse existing R tools where appropriate.

**November 2025** - Bioconductor 3.22. OME-Zarr 1.0 package included in release.

It is anticipated that the work developing features of the OME-Zarr package will continue, alongside software maintenance tasks as the usage of Rarr increases. During this phase of the project we will also collaborate with developers working on other Zarr focused data formats. Existing examples include SpatialData (https://github.com/HelenaLC/SpatialData) and specprepper (https://github.com/spectral-cockpit/specprepper) and it is expected that several others will have emerged the were enabled by the work already completed.  We would consider the project a success if at least 5 new R / Biocondutor packages depended on Rarr.

**April 2026** - Bioconductor 3.23.

### Deliverables:

A revised Rarr package (version 2.0), with full support for Zarr v3 as well as any additional Zarr features defined and released during the project duration.
A ZarrArray class with R-array semantics and optimised “on-disk aware” operations using the DelayedArray framework.
A new R package focused on the OME-Zarr format.  This will provide the OME-Zarr class representing the structure of this imaging format, with methods to perform standard operations including image I/O, generating multiscale images, transformations and labelling.  These tools will be integrated into other Bioconductor packages e.g. iSEE (EOSS6-0000000342)

## 8. Existing Support: 
List active and recently completed (previous two calendar years) financial or in-kind support for the software project(s), including duration, total costs in USD, and source of funding. Include any previous funding for these software projects received from CZI, Wellcome, and/or Kavli outside of the EOSS program (maximum of 250 words). 

Mike Smith conducted the initial development work on Rarr between December 2022 and May 2023.  Funding for his position was obtained by Wolfgang Huber as part of a larger project funded by the German state of Baden-Württemberg to establish bioinformatics infrastructure, with a remit to maintain existing services and innovate new ones to meet user needs. This funding has now ended and Dr Smith has transferred to a new position at the EMBL.  His continuing upkeep of Rarr is currently provided on an in-kind basis as time allows.
9. Landscape Analysis: 

Auto-filled from LOI. Describe the other software tools (either proprietary or open source) that the audience for this proposal primarily uses. How do the software project(s) in this proposal compare to these other tools in terms of user base size, usage, and maturity? How do existing tools and the project(s) in this proposal interact? (maximum of 250 words).

Bioconductor is a well-established and influential open-source and open-development project.  It includes more than 2,100 software packages, created by a world-wide pool of developers, which are downloaded by > 100,000 unique IPs every month.  Bioconductor code is developed in public git repositories, the software packages are continually integration-tested and released via standardised distribution mechanisms. There exist several active support channels for users and developers.

The Zarr format is seeing adoption across a wide variety of research fields, and mature tools for working with Zarr are available in Python, C, C++, Java, Javascript, Julia, & Rust among others.  However, until recently, adoption of the format in R lagged behind, as no viable R implementation existed.  Although a variety of efforts to provide an R interface to Zarr can be found online, most are prototype efforts that are now dormant.  Rarr represents the first R package to provide comprehensive coverage of the Zarr specification, and although only widely released via Bioconductor in the last 6 months, it is seeing growing engagement on GitHub and  increasing downloads from the Bioconductor repository. Efforts to access spatial-omics datasets are making use of Rarr (https://github.com/HelenaLC/SpatialData). One recent endeavour to create an alternate R/Zarr interface is pizzarr (https://github.com/keller-mark/pizzarr), which relies on Rarr for some operations.

The developers of Rarr are closely linked to the Bioconductor project as core team members and via representation on the Technical and Community Advisory Boards, and are engaged with the Zarr development community.

## 10. Value to Biomedical Users: 

OME-Zarr is rapidly being adopted as a widely used target format to store and exchange data from a large variety of bioimaging experiments. For example, repositories such as the EMBL-EBI BioImage Archive are increasingly making image data in this format available from cloud storage. By providing robust support for the OME-Zarr specification in the R/Bioconductor ecosystem, we will further strengthen that adoption. Bioconductor contains comprehensive and well-established tools for sequencing data, and by improving support for popular imaging standards we will open up the possibility for researchers to leverage this extensive range of tools to analyse experiments with multiple data modalities.

Furthermore, our proposed work to improve support for the Zarr specification in R will have many benefits to biomedical users beyond the scope of imaging. Analysing modern single-cell sequencing and methylation experiments requires smooth interaction with large multi-dimensional array data.  The size of these datasets is often prohibitive to working with them in main computer memory, and formats such as HDF5 and TileDB are well supported Bioconductor as platforms for out-of-memory access.  Given Zarr’s increasing prominence in this space, with support in other data structures such as AnnData (https://anndata.readthedocs.io/) that are widely used in biomedical data analysis, it is important to keep pace with the changing needs of researchers.  Our work will ensure that analysts using Bioconductor tools will be able to work effectively with this emerging data standard, making use of the most appropriate language and tools at each stage of an analysis workflow.

## 11. Category: 

Choose the two categories that best describe the software project(s) audience:

- Bioinformatics 
- Single-cell biology 
- Structural biology 
- Clinical research 
- Genomics 
- Neuroscience 
- Infectious disease 
- **Imaging**
- **Data management and workflows**
- Machine learning and data analysis 
- Visualization 

## 12. Diversity, Equity, and Inclusion (DEI) statement: 
Advancing DEI is a core value for this program, and we are requesting information on your efforts in this area. Describe any efforts the software project(s) named in this proposal have undertaken to increase diversity, equity, and inclusion with respect to their contributors and audience. Please see examples from applications funded in previous cycles (maximum of 250 words).

EMBL is curiosity-driven, community-oriented and international. As an inclusive, equal opportunity employer, we believe that diversity enables us to collaborate more effectively and be innovative in our approaches. We are, therefore, committed to creating an inclusive and flexible culture - one where everyone can realise their full potential and make a positive contribution to our organisation. We encourage applications from individuals who can complement our existing team – we believe that success is built on having teams whose backgrounds and personal experiences reflect the diversity of the populations that our science serves. We actively encourage applications from all genders and cultures, ethnic groups and all demographics to help us avoid perpetuating biases and oversights at this transformational point in our people strategy.

These values are well-reflected in the efforts of the team involved in this proposal. The Huber group has spearheaded efforts at the intersection of DEI and computational biology, using the Bioconductor platform to popularise and standardise open-source, accessible computational tools world-wide, as well as recruit diverse new scientists to the field via its conferences. Mike Smith is a member of the Bioconductor Community Advisory board, a body specifically created to empower user and developer communities by coordinating training opportunities, and enabling productive and respectful participation in the project.  In particular he has been leading efforts to pair new package developers, who may not be familiar with Bioconductor, with more experienced mentors from within the project community.


