% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeSensitivityProfiles-methods.R
\name{summarizeSensitivityProfiles,RadioSet-method}
\alias{summarizeSensitivityProfiles,RadioSet-method}
\title{Takes the sensitivity data from a RadioSet, and summarises them into a
drug vs cell line table}
\usage{
\S4method{summarizeSensitivityProfiles}{RadioSet}(
  object,
  sensitivity.measure = "AUC_recomputed",
  cell.lines,
  radiation.types,
  summary.stat = c("mean", "median", "first", "last", "max", "min"),
  fill.missing = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{`RadioSet` The RadioSet from which to extract the data}

\item{sensitivity.measure}{`character` which sensitivity sensitivity.measure to use? Use the
sensitivityMeasures function to find out what measures are available for each PSet.}

\item{cell.lines}{`character` The cell lines to be summarized.
 If any cell lines has no data, it will be filled with
missing values}

\item{radiation.types}{`character` The radiation types to be summarized.
If any radiation type has no data, it will be filled with
missing values}

\item{summary.stat}{`character` which summary method to use if there are repeated
cell line-drug experiments? Choices are "mean", "median", "first", or "last"}

\item{fill.missing}{`logical(1)` should the missing cell lines not in the
molecular data object be filled in with missing values?}

\item{verbose}{Should the function print progress messages?}
}
\value{
[matrix] A matrix with cell lines going down the rows, radiation types across
  the columns, with the selected sensitivity statistic for each pair.
}
\description{
This function creates a table with cell lines as rows and radiation types as columns,
summarising the drug senstitivity data of a RadioSet into drug-cell line
pairs
}
\examples{
data(clevelandSmall)
GDSCauc <- summarizeSensitivityProfiles(clevelandSmall, sensitivity.measure='AUC_published')

}
