% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateGEdata.R
\name{simulateGEdata}
\alias{simulateGEdata}
\title{Simulate gene expression data.}
\usage{
simulateGEdata(
  n,
  m,
  k,
  size.alpha,
  corr.strength,
  g = NULL,
  Sigma.eps = 0.1,
  nc,
  ne,
  intercept = TRUE,
  check.input = FALSE
)
}
\arguments{
\item{n}{An integer setting the number of genes.}

\item{m}{An integer setting the number of arrays.}

\item{k}{An integer setting number of dimensions of noise term, 
controls dimension of \eqn{W} and \eqn{\alpha}.}

\item{size.alpha}{A numeric scalar giving the maximal and 
minimal absolute value of \eqn{\alpha}.}

\item{corr.strength}{An integer controlling the dimension of \eqn{X} and \eqn{\beta}.}

\item{g}{An integer value between [1, min(\code{k}, \code{corr.strength})) giving the 
correlation between \eqn{X} and \eqn{W} or \code{NULL} for independence.}

\item{Sigma.eps}{A numeric scalar setting the amount of random variation in 
\eqn{\epsilon}; \code{Sigma.eps} \eqn{>0}.}

\item{nc}{An integer setting the number of negative controls.}

\item{ne}{An integer setting the number of strongly expressed genes.}

\item{intercept}{An logical value indicating whether the systematic noise has an intercept.}

\item{check.input}{A logical scalar; if \code{TRUE} all input is checked 
(not advisable for large simulations).}
}
\value{
\code{simulateGEdata} returns output of the class \code{simulateGEdata}.
An object of class \code{simulateGEdata} is a \code{list} with the 
following components:
    \itemize{
      \item{\code{Truth}}{ A matrix containing the values of \eqn{X\beta}.}
      \item{\code{Y}}{ A matrix containing the values in \eqn{Y}.}
      \item{\code{Noise}}{ A matrix containing the values in \eqn{W\alpha}.} 
      \item{\code{Sigma}}{ A matrix containing the true gene-gene correlations, as defined by \eqn{X\beta}.}
      \item{\code{Info}}{ A matrix containing some of the general information about the simulation.}
    }
}
\description{
\code{simulateGEdata} returns simulated noisy gene expression values of specified size 
and its underlying gene-gene correlation.
}
\details{
This function generates log2-transformed expression values of \code{n} genes in 
\code{m} arrays. The expression values consist of true expression and noise:
\deqn{Y=X\beta+W\alpha+\epsilon}
The dimensions of the matrices \eqn{X} and \eqn{\beta} are used to control the size of
the correlation between the genes. It is possible to simualte three different classes
of genes:
    \itemize{
      \item correlated genes expressed with true log2-transformed values from 0 to 16
      \item correlated genes expressed with true log2-transformed values with mean 0
      \item uncorrelated genes with true log2-transformed expression equal to 0 (negative controls)
   }
The negative control are always the last \code{nc} genes in the data, 
whereas the strongly expressed genes are always the first \code{ne} genes in the data.
The parameter \code{intercept} controls whether the systematic noise has an 
offset or not. Note that the intercept is one dimension of \eqn{W}.
It is possible to either simulate data where \eqn{W} and \eqn{X} are independent by
setting \code{g} to NULL, or increasing correlation \eqn{bWX} between 
\eqn{W} and \eqn{X} by increasing \code{g}.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=TRUE, check.input=TRUE)
Y
Y<-simulateGEdata(500, 500, 10, 2, 5, g=3, Sigma.eps=0.1, 
250, 100, intercept=TRUE, check.input=TRUE)
Y
}
\references{
Jacob L., Gagnon-Bartsch J., Speed T. Correcting gene expression 
  data when neither the unwanted variation nor the factor of interest are observed. 
  Berkley Technical Reports (2012).
}
\author{
Saskia Freytag, Johann Gagnon-Bartsch
}
