% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotThreshold.R
\name{plotThreshold}
\alias{plotThreshold}
\title{Plots an object of class \code{Threshold}.}
\usage{
plotThreshold(x, main = "", legend, col = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{Threshold} or a list of objects of class \code{Threshold}.}

\item{main}{A character string describing the title of the plot.}

\item{legend}{A vector of character strings decribing the different \code{Threshold} objects in
\code{x}; only applicable when x is a list.}

\item{col}{A vector giving the colors, if \code{NULL} colors
are generated automatically.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\code{plotThreshold} returns a plot.
}
\description{
\code{plotThreshold} plots the objects of class \code{Threshold}.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
anno<-as.matrix(sample(1:4, dim(Y$Y)[1], replace=TRUE))
colnames(anno)<-"Factor"
weights<-findWeights(Y$Y, anno, "Factor")
Thresh<-calculateThreshold(Y$Y, exclude=1:100, index.ref=1:10, 
Weights=weights, anno=anno, Factor="Factor")
plotThreshold(Thresh)
}
\seealso{
\code{\link{calculateThreshold}}
}
\author{
Saskia Freytag
}
