% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empNegativeControls.R
\name{empNegativeControls}
\alias{empNegativeControls}
\alias{empNegativeControls.default}
\alias{empNegativeControls.simulateGEdata}
\title{Empirically choose negative control genes.}
\usage{
empNegativeControls(Y, exclude, smoothing = 0.1, nc)

\method{empNegativeControls}{default}(Y, exclude, smoothing = 0.1, nc)

\method{empNegativeControls}{simulateGEdata}(Y, exclude, smoothing = 0.1, nc)
}
\arguments{
\item{Y}{A matrix of gene expression values or an 
object of the class \code{simulateGEdata}.}

\item{exclude}{A vector of indices to be excluded from being chosen
as negative controls.}

\item{smoothing}{A numerical scalar determining the amount of smoothing to be applied.}

\item{nc}{An integer setting the number of negative controls.}
}
\value{
\code{empNegativeControls} returns a vector of indicies of 
empirically chosen negative controls.
}
\description{
\code{empNegativeControls} finds suitable negative controls in real or simulated data.
}
\details{
First the mean of all genes (except the excluded genes) is calculated 
and genes are accordingly assigned to bins. The bins have the size
of the smoothing parameter. In each bin the function picks a number of negative control 
genes proportional to the total number of genes in the bin. 
The picked genes in each bin have the lowest inter-quantile ranges of all 
genes in the respective bin.
}
\section{Warning}{

For simulated data it is advisable to use the known negative controls or 
restrict the empirical
choice to the known negative controls by excluding all other genes.
}

\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=TRUE)
empNegativeControls(Y, exclude=1:100, nc=100)
}
\author{
Saskia Freytag
}
