% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareRanks.R
\name{compareRanks}
\alias{compareRanks}
\title{Compare ranking of known reference gene pairs.}
\usage{
compareRanks(Y, Y.hat, ref_index, no.random = 1000, exclude_index)
}
\arguments{
\item{Y}{A matrix of raw gene expression values.}

\item{Y.hat}{A matrix of cleaned gene expression values.}

\item{ref_index}{A vector of indices that are referrring to genes of interest.}

\item{no.random}{An integer giving the number of random genes.}

\item{exclude_index}{A vector of indices to be excluded from the selection of random 
genes.}
}
\value{
\code{compareRanks} returns a vector of the differences in ranks of 
the correlations of reference gene pairs estimated using raw or cleaned data.
}
\description{
\code{compareRanks} allows to calculate the difference of the ranks of known reference 
gene pairs from two versions of the same data.
}
\details{
The correlations between all random genes and reference genes is calculated 
(including correlations between random and reference) using the two versions of
the data. The correlations are then ranked according to their absolute value (highest
to lowest). The ranks of the reference gene pairs are extracted. For a paticular 
reference gene pair, the difference in the ranks between the two versions of the data 
is calculated:
Rank in \code{Y} - Rank in \code{Y.hat}
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, 
Sigma.eps=0.1, 250, 100, intercept=FALSE, check.input=FALSE)
Y.hat<-RUVNaiveRidge(Y, center=TRUE, nu=0, kW=10)
compareRanks(Y$Y, Y.hat, ref_index=1:30, no.random=100, exclude_index=c(31:100,251:500))
}
\author{
Saskia Freytag
}
