% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RUVNaiveRidge.R
\name{RUVNaiveRidge}
\alias{RUVNaiveRidge}
\alias{RUVNaiveRidge.default}
\alias{RUVNaiveRidge.simulateGEdata}
\title{Removal of unwanted variation for gene correlations.}
\usage{
RUVNaiveRidge(Y, center = TRUE, nc_index, nu, kW, check.input = FALSE)

\method{RUVNaiveRidge}{default}(Y, center = TRUE, nc_index, nu, kW, check.input = FALSE)

\method{RUVNaiveRidge}{simulateGEdata}(Y, center = TRUE, nc_index, nu, kW, check.input = FALSE)
}
\arguments{
\item{Y}{A matrix of gene expression values or an object of 
class \code{simulateGEdata}.}

\item{center}{A logical scalar; if \code{TRUE} the data is centered, 
if \code{FALSE} data is assumed to be already centered.}

\item{nc_index}{A vector of indices of negative controls.}

\item{nu}{A numeric scalar value of \code{nu} \eqn{\geq 0}.}

\item{kW}{An integer setting the number of dimensions for the estimated noise.}

\item{check.input}{A logical scalar; if \code{TRUE} all input is 
checked (not advisable for large simulations).}
}
\value{
\code{RUVNaiveRidge} returns a matrix of the cleaned 
(RUV-treated) centered gene expression values.
}
\description{
\code{RUVNaiveRidge} applies the ridged version of global removal of unwanted variation 
to simulated or real gene expression data.
}
\details{
The parameter \code{kW} controls how much noise is cleaned, whereas the 
parameter \code{nu} controls the amount of ridging to deal with possible dependence of 
the noise and the factor of interest.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=TRUE, check.input=FALSE)
Y
Y.hat<-RUVNaiveRidge(Y, center=TRUE, nc_index=251:500, 0, 9, check.input=TRUE)
cor(Y.hat[,1:5])
Y$Sigma[1:5,1:5]
Y.hat<-RUVNaiveRidge(Y, center=FALSE, nc_index=251:500, 0, 10, check.input=TRUE)
cor(Y.hat[,1:5])
Y$Sigma[1:5,1:5]
}
\references{
Jacob L., Gagnon-Bartsch J., Speed T. Correcting gene expression 
  data when neither the unwanted variation nor the factor of interest are observed. 
  Berkley Technical Reports (2012).
}
\author{
Saskia Freytag, Laurent Jacob
}
