% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLEPlot.R
\name{RLEPlot}
\alias{RLEPlot}
\title{Plots different versions of relative log expression plots}
\usage{
RLEPlot(
  X,
  Y,
  center = TRUE,
  name,
  title,
  method = c("IQR.points", "IQR.boxplots", "minmax"),
  anno = NULL,
  Factor = NULL,
  numeric = FALSE,
  new.legend = NULL,
  outlier = FALSE
)
}
\arguments{
\item{X}{A matrix of gene expression values.}

\item{Y}{A matrix of gene expression values.}

\item{center}{A logical scalar; \code{TRUE} if centering should be applied.}

\item{name}{A vector of characters describing the data contained in 
\code{X} and \code{Y}.}

\item{title}{A character string describing the title of the plot.}

\item{method}{The type of RLE plot to be displayed; possible inputs are 
\code{"IQR.points"}, \code{"IQR.boxplots"} and \code{"minmax"} 
(for information see details).}

\item{anno}{A dataframe or a matrix containing the annotation of 
arrays in \code{X} and \code{Y} (only applicable for \code{method="IQR.points"});
if \code{anno=NULL} data points are not colored.}

\item{Factor}{A character string corresponding to a column name of 
\code{anno} to be used for coloring.}

\item{numeric}{A logical scalar indicating whether \code{Factor} is numerical.}

\item{new.legend}{A vector describing the names used for labelling; if \code{NULL} 
labels in \code{Factor} are used.}

\item{outlier}{A logical indicating whether outliers should be plotted; only 
applicable when \code{method="minmax"}.}
}
\value{
\code{RLEPlot} returns a plot.
}
\description{
\code{RLEPlot} generates three different types of 
relative log expression plots for high-dimensional data.
}
\details{
There are three different RLE plots that can be generated using \code{RLEPlot}:
   \describe{
     \item{\code{"IQR.points"}}{Median expression vs. inter-quantile range of every array.}
     \item{\code{"IQR.boxplots"}}{Boxplots of the 25\% and 75\% quantile of all arrays.}
     \item{\code{"Minmax"}}{Ordinary RLE plots for the 5 arrays with the smallest and largest inter-quantile ranges.}
   }
Note that normal RLE plots are not supplied as they 
are not very suitable for high-dimensional data.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
Y.hat<-RUVNaiveRidge(Y, center=TRUE, nc_index=251:500, 0, 10, check.input=TRUE)
try(dev.off(), silent=TRUE)
par(mar=c(5.1, 4.1, 4.1, 2.1), mgp=c(3, 1, 0), las=0)
RLEPlot(Y$Y, Y.hat, name=c("Raw", "RUV"), title="", method="IQR.points")
try(dev.off(), silent=TRUE)
par(mfrow=c(1, 1))
RLEPlot(Y$Y, Y.hat, name=c("Raw", "RUV"), title="", method="IQR.boxplots")
try(dev.off(), silent=TRUE)
RLEPlot(Y$Y, Y.hat, name=c("Raw", "RUV"), title="", method="minmax")

#Create a random annotation file
anno<-as.matrix(sample(1:4, dim(Y.hat)[1], replace=TRUE))
colnames(anno)<-"Factor"
try(dev.off(), silent=TRUE)
RLEPlot(Y$Y, Y.hat, name=c("Raw", "RUV"), title="", method="IQR.points",
anno=anno, Factor="Factor", numeric=TRUE)
}
\author{
Saskia Freytag, Terry Speed
}
