% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAPlot.R
\name{PCAPlot}
\alias{PCAPlot}
\title{Plot principle component analysis for gene expression data.}
\usage{
PCAPlot(
  Y,
  comp = c(1, 2),
  anno = NULL,
  Factor = NULL,
  numeric = FALSE,
  new.legend = NULL,
  title
)
}
\arguments{
\item{Y}{A matrix of gene expression values or an object of class \code{prcomp}.}

\item{comp}{A vector of length 2 specifying which principle components to be used.}

\item{anno}{A dataframe or a matrix containing the annotation of the arrays.}

\item{Factor}{A character string describing the column name of 
\code{anno} used for coloring.}

\item{numeric}{A logical scalar indicating whether \code{Factor} is numerical.}

\item{new.legend}{A vector describing the names used for labelling; if \code{NULL} 
labels in \code{Factor} are used.}

\item{title}{A character string giving the title.}
}
\value{
\code{PCAPlot} returns a plot.
}
\description{
\code{PCAPlot} generates principle component plots for with the possibility
to color arrays according to a known factor.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
PCAPlot(Y$Y, title="")

## Create random annotation file
anno<-as.matrix(sample(1:4, dim(Y$Y)[1], replace=TRUE))
colnames(anno)<-"Factor"
try(dev.off(), silent=TRUE)
par(mar=c(5.1, 4.1, 4.1, 2.1), mgp=c(3, 1, 0), las=0, mfrow=c(1, 1))
PCAPlot(Y$Y, anno=anno, Factor="Factor", numeric=TRUE, title="")
}
\seealso{
\code{\link[stats]{prcomp}}
}
\author{
Saskia Freytag
}
