% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnsSRD.R
\docType{methods}
\name{tnsSRD,TNS-method}
\alias{tnsSRD,TNS-method}
\alias{tnsSRD}
\title{Subgroup Regulon Difference for TNS-class objects}
\usage{
\S4method{tnsSRD}{TNS}(
  tns,
  subgroup,
  pValueCutoff = 0.05,
  pAdjustMethod = "BH",
  regs = NULL,
  verbose = TRUE
)
}
\arguments{
\item{tns}{A A \linkS4class{TNS} object.}

\item{subgroup}{a character vector. It must be the name of a column in the
survivalData featuring the grouping information as a categorical variable.}

\item{pValueCutoff}{a single numeric value specifying the cutoff for 
p-values considered significant.}

\item{pAdjustMethod}{a single character value specifying the p-value 
adjustment method to be used (see 'p.adjust' for details).}

\item{regs}{An optional string vector specifying regulons to use for the analysis.}

\item{verbose}{a logical value specifying whether to display messages and
progress bar.}
}
\value{
A TNS-class object with the results of the subgroup regulon difference
added to the results slot. To recover the results, use tnsGet(tns, "regulonDifference")
}
\description{
This regulon evaluates differences between regulon activity of subgroups of
samples, given a grouping variable. It performs Wilcoxon-Mann-Whitney 
(2 subgroups) or Kruskal-Wallis (3+ subgroups) Rank Sum Tests to check whether
the activity scores of a given regulon are different between subgroups of samples.
}
\examples{
# load survival data
data(survival.data)
# load TNI-object
data(stni, package = "RTN")

# create TNS object
stns <- tni2tnsPreprocess(stni, survivalData = survival.data,
                          keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

# run subgroup regulon enrichment analysis
stns <- tnsSRD(stns, "ER+")

}
