% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsKmInteraction,TNS-method}
\alias{tnsKmInteraction,TNS-method}
\alias{tnsKmInteraction}
\title{Kaplan-Meier analysis for dual regulons}
\usage{
\S4method{tnsKmInteraction}{TNS}(
  tns,
  regs1 = NULL,
  regs2 = NULL,
  stepFilter = TRUE,
  pValueCutoff = 0.05,
  phiThreshold = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{regs1}{An optional character vector specifying regulons to test
for interaction. If missing, it will be used all regulons listed in the 
'TNS' object.}

\item{regs2}{An optional character vector specifying regulons to test
for interaction. If missing, it will be used all regulons listed in the 
'TNS' object.}

\item{stepFilter}{A single logical value specifying to use a step-filter 
algorithm, testing dual regulons that have at least one significant predictor
in the 'tnsKM' method (when stepFilter=TRUE) or not (when stepFilter=FALSE).}

\item{pValueCutoff}{A numeric value in [0,1]. The p-value cutoff applied to 
the results from the previous steps of the analysis pipeline 
(when stepFilter=TRUE).}

\item{phiThreshold}{A numeric value in [0,1]. The 'phi' coefficient is a 
measure of association between two dichotomous variables. Here, a threshold 
on 'phi' is used to remove regulon pairs with 'strong' dependencies.}

\item{verbose}{A logical value specifying to display detailed messages 
(when verbose=TRUE) or not (when verbose=FALSE).}
}
\value{
Results from 'survfit' and 'survdiff', including log-rank statistics.
}
\description{
Kaplan-Meier analysis for dual regulons, assessing the interaction between regulons.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

# KM analysis for dual regulons
# stns <- tnsKmInteraction(stns, stepFilter = FALSE)
# tnsGet(stns, "kmInteractionTable")

}
