% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsGSEA2,TNS-method}
\alias{tnsGSEA2,TNS-method}
\alias{tnsGSEA2}
\title{Compute regulon activity using 2-tailed Gene Set Enrichment Analysis}
\usage{
\S4method{tnsGSEA2}{TNS}(tns, ...)
}
\arguments{
\item{tns}{A \linkS4class{TNS} class, which has been preprocessed}

\item{...}{Additional parameters passed to \code{\link{tni.gsea2}} function.}
}
\value{
A \linkS4class{TNS} class, with added regulon activity scores.
}
\description{
Works as a wrapper for \code{\link{tni.gsea2}}, performing a 
2-tailed GSEA analysis on a \linkS4class{TNI} class object and integrating 
the results into the \linkS4class{TNS} class object.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

\dontrun{

# parallel version with SNOW package!
library(snow)
options(cluster=snow::makeCluster(3, "SOCK"))
stns <- tnsGSEA2(stns)
stopCluster(getOption("cluster"))

}

}
\seealso{
\code{\link{tni.gsea2}} for information on all 
parameters.
}
