% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBR-methods.R
\docType{methods}
\name{tni2mbrPreprocess,TNI-method}
\alias{tni2mbrPreprocess,TNI-method}
\alias{tni2mbrPreprocess}
\title{A preprocessing function for objects of class MBR.}
\usage{
\S4method{tni2mbrPreprocess}{TNI}(tni, regulatoryElements = NULL)
}
\arguments{
\item{tni}{A 'TNI' class object.}

\item{regulatoryElements}{An optional character vector specifying which 
'TNI' regulatory elements should be evaluated. If 'NULL' all regulatory 
elements will be evaluated.}
}
\value{
An \linkS4class{MBR} object.
}
\description{
This function converts a TNI class objects and into one MBR class object.
}
\examples{
##--- load a dataset for demonstration
data("tniData", package = "RTN")
tfs <- c("IRF8","IRF1","PRDM1","E2F3","STAT4","LMO4","ZNF552")

##--- construct a tni object
rtni <- tni.constructor(tniData$expData, regulatoryElements = tfs, 
rowAnnotation=tniData$rowAnnotation)

##--- compute regulons 
## set nPermutations>=1000
rtni <- tni.permutation(rtni, nPermutations=30)

## set nBootstrap>=100
rtni <- tni.bootstrap(rtni, nBootstrap=30)

## 'eps=NA' estimates threshold from empirical null
rtni <- tni.dpi.filter(rtni, eps=NA)

##--- construct a mbr object
rmbr <- tni2mbrPreprocess(rtni)

}
