% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBR-methods.R
\docType{methods}
\name{mbrPriorEvidenceTable,MBR-method}
\alias{mbrPriorEvidenceTable,MBR-method}
\alias{mbrPriorEvidenceTable}
\title{Entry point for external evidences.}
\usage{
\S4method{mbrPriorEvidenceTable}{MBR}(
  object,
  priorEvidenceTable,
  evidenceColname,
  verbose = TRUE
)
}
\arguments{
\item{object}{A processed object of class \linkS4class{MBR} evaluated by the 
method \code{\link{mbrAssociation}}.}

\item{priorEvidenceTable}{An 'data.frame' with three columns 
representing (1) regulatory elements 1, (2) regulatory elements 2,
and (3) external evidences between the regulatory elements.}

\item{evidenceColname}{A single character value specifying a column in 
the 'priorEvidenceTable'.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when verbose=TRUE) or not (when verbose=FALSE).}
}
\value{
An \linkS4class{MBR} object with an updated 'data.frame' in the slot 
'results' listing the input additional evidences.
}
\description{
If available, this function adds external evidences to an 'MBR' object.
}
\examples{
##--- load a dataset for demonstration
data("tniData", package = "RTN")
gexp <- tniData$expData
annot <- tniData$rowAnnotation
tfs <- c("IRF8","IRF1","PRDM1","E2F3","STAT4","LMO4","ZNF552")

##--- construct a tni object
rtni <- tni.constructor(gexp, regulatoryElements = tfs, rowAnnotation=annot)

##--- compute regulons 
## set nPermutations>=1000
rtni <- tni.permutation(rtni, nPermutations=30)
## set nBootstrap>=100
rtni <- tni.bootstrap(rtni, nBootstrap=30)
## 'eps=NA' estimates threshold from empirical null
rtni <- tni.dpi.filter(rtni, eps=NA)

##--- construct a mbr object
rmbr <- tni2mbrPreprocess(rtni)

##--- run mbrAssociation 
## set nPermutations>=1000
rmbr <- mbrAssociation(rmbr, pValueCutoff = 0.05, nPermutations=30)

##--- check results
results <- mbrGet(rmbr, what="dualsCorrelation")

##--- add supplementary evidence table
## here we build a 'toy' example using the 'rnorm' function 
## for demonstration purposes only!
priorEvidenceTable <- results[,c("Regulon1","Regulon2")]
priorEvidenceTable$ToyEvidence <- rnorm(nrow(results))
priorEvidenceTable

##--- add supplementary evidences
# rmbr <- mbrPriorEvidenceTable(rmbr, priorEvidenceTable=priorEvidenceTable, evidenceColname = "ToyEvidence")

##--- check updated results
# mbrGet(rmbr, what="dualsCorrelation")

}
