% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MBR-class}
\alias{MBR-class}
\alias{MBR}
\title{MBR objects}
\description{
MBR: an S4 class for co-regulation analysis and inference of 'dual 
regulons'.
}
\details{
The MBR class is a container for results from the MBR methods. 
The class slots are used to store information of different transcriptional networks, 
regulator annotation, infered 'dual regulons' and parameters used in the analysis. 
All the information is stored in nine slots.
}
\section{Slots}{

\describe{
\item{\code{TNI}}{a 'TNI' object created by the RTN package.}

\item{\code{regulatoryElements}}{regulatory elements listed in the TNI.}

\item{\code{dualRegulons}}{all possible 'duals regulons' computed by 
\code{\link{mbrAssociation}}}

\item{\code{results}}{a list, results from the MBR methods.}

\item{\code{para}}{a list, parameters used in the MBR methods.}

\item{\code{summary}}{a list, summary for 'para' and 'results'.}

\item{\code{status}}{a character vector specifying the status of the MBR object 
based on the available methods.}
}}

\section{Constructor}{


There is one constructors to create an MBR object: 
\code{\link{tni2mbrPreprocess}};
}

