% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTCGA.R
\name{downloadTCGA}
\alias{downloadTCGA}
\title{Download TCGA Data}
\usage{
downloadTCGA(
  cancerTypes,
  dataSet = "Merge_Clinical.Level_1",
  destDir,
  date = NULL,
  untarFile = TRUE,
  removeTar = TRUE,
  allDataSets = FALSE
)
}
\arguments{
\item{cancerTypes}{A character vector containing abbreviations (Cohort code) of types of cancers to download from 
\href{https://gdac.broadinstitute.org/}{https://gdac.broadinstitute.org/}. For easy access from R check details below.}

\item{dataSet}{A part of the name of dataSet to be downloaded from \href{https://gdac.broadinstitute.org/runs/}{https://gdac.broadinstitute.org/runs/}. By default the Merged Clinical dataSet is downloaded (value \code{dataSet = 'Merge_Clinical.Level_1'}). Available datasets' names can be checked using \link{checkTCGA} function.}

\item{destDir}{A character specifying a directory into which \code{dataSet}s will be downloaded.}

\item{date}{A \code{NULL} or character specifying from which date \code{dataSet}s should be downloaded.
By default (\code{date = NULL}) the newest available date is used. All available dates can be checked on 
\href{https://gdac.broadinstitute.org/runs/}{https://gdac.broadinstitute.org/runs/} or by using \link{checkTCGA} 
function. Required format \code{'YYYY-MM-DD'}.}

\item{untarFile}{Logical - should the downloaded file be untarred. Default is \code{TRUE}.}

\item{removeTar}{Logical - should the downloaded \code{.tar} file be removed after untarring.
Default is \code{TRUE}.}

\item{allDataSets}{Logical - should download all datasets matching \code{dataSet} parameter or only the first one (without \code{FFPE} phrase if possible).}
}
\value{
No values. It only downloads files.
}
\description{
Enables to download TCGA data from specified dates of releases of concrete Cohorts of cancer types.
Pass a name of required dataset to the \code{dataSet} parameter. By default the Merged Clinical
dataSet is downloaded (value \code{dataSet = 'Merge_Clinical.Level_1'}) from the newest available date of the release.
}
\details{
All cohort names can be checked using: \code{ sub( x = names( infoTCGA() ), '-counts', '' )}.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{


dir.create('hre')

downloadTCGA(cancerTypes = 'ACC',
             dataSet = 'miR_gene_expression',
             destDir = 'hre',
             date = tail(checkTCGA('Dates'), 2)[1])

\dontrun{
downloadTCGA(cancerTypes = c('BRCA', 'OV'),
             destDir = 'hre',
             date = tail(checkTCGA('Dates'), 2)[1])
}



}
\seealso{
\pkg{RTCGA} website \href{https://rtcga.github.io/RTCGA/articles/Data_Download.html}{https://rtcga.github.io/RTCGA/articles/Data_Download.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
