% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTCGA.R
\name{createTCGA}
\alias{createTCGA}
\title{Create RTCGA.dataType.releaseDate-like Packages with TCGA Datasets}
\usage{
createTCGA(
  description = file.path(getwd(), "DESCRIPTION"),
  cohorts = sub("-counts", "", rownames(infoTCGA())),
  tempDir = "data_tmp",
  clean = FALSE
)
}
\arguments{
\item{description}{A regular \href{http://r-pkgs.had.co.nz/description.html}{DESCRIPTION} file with additional extra records: \code{TCGAdataSet}, \code{TCGAreleaseDate} (\code{releaseDate} and \code{dataSet} to be used in \code{downloadTCGA}) and \code{TCGAdataType} (a type of data to be used in \link{readTCGA}).}

\item{cohorts}{Names of cancer type cohorts to be included in the package. For possible names check \link{infoTCGA}.}

\item{tempDir}{The name of temporary directory in which the data will be stored during package creation.}

\item{clean}{A logical: should the \code{tempDir} directory be removed after package creation.}
}
\value{
A fully equpied package, ready to be shipped on Bioconductor's ExperimentHub.
}
\description{
This uber functionality allows to create packages with datasets from the TCGA project. 
Example of such a package created with \code{createTCGA} is \url{https://github.com/RTCGA/RTCGA.clinical.20160128}.
Resulted package is a package of type \href{http://www.bioconductor.org/packages/3.4/bioc/vignettes/ExperimentHubData/inst/doc/ExperimentHubData.html}{ExperimentHubData},
it consists of regular structure like \code{R} and \code{man} directories and also cosists of a vignette and \code{README.md} file where the whole 
construction process is decribed. The only part which must be pre-specified by a user is a \code{DESCRIPTION} file with additional extra records: 
\code{TCGAdataSet}, \code{TCGAreleaseDate} (\code{releaseDate} and \code{dataSet} to be used in \code{downloadTCGA}) and \code{TCGAdataType} (a type of data to be used in \link{readTCGA}).
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

\dontrun{

# https://github.com/RTCGA/RTCGA.clinical.20160128
# RTCGA.clinical.20160128 was created with
cat(
 readLines(
   'https://raw.githubusercontent.com/RTCGA/RTCGA.clinical.20160128/master/DESCRIPTION'
), file = 'DESC', sep = '\n')
createTCGA('DESC', clean = TRUE)

} 


}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/}{http://rtcga.github.io/RTCGA/}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
