% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mergeTCGA.R
\name{mergeTCGA}
\alias{mergeTCGA}
\title{Merge Clinical data with genes' Mutations and Expressions data}
\usage{
mergeTCGA(clinicalDir, rnaseqDir = NULL, mutationDir = NULL, genes,
  columnName = "Variant_Classification")
}
\arguments{
\item{clinicalDir}{A directory to a \code{cancerType.clin.merged.txt} file.
\code{cancerType} might be \code{BRCA, OV} etc. Can be checked using \link{infoTCGA} function.}

\item{rnaseqDir}{A directory to a \code{cancerType.rnaseqv2__illuminahiseq_rnaseqv2__unc_edu__Level_3__RSEM_genes_normalized__data.data.txt} file,
which is a set with gene's Expressions.}

\item{mutationDir}{A directory to a \code{Mutation_Packager_Calls.Level} folder where are genes' Mutations files.}

\item{genes}{For \code{rnaseqDir} - which genes' expressions to merge with clinical data in \code{clinicalDir}. For \code{mutationDir} which
gene's mutations to merge with clinical data in \code{clinicalDir}.}

\item{columnName}{A character specifing which column to extract from \code{Mutations} data for a gene passes to \code{genes} parameter.
Works only when \code{mutationDir} was used.}
}
\value{
A \code{cancerType.clin.merged.txt} file is updated with newline containing informations about genes
passed to \code{genes} argument.
}
\description{
\code{mergeTCGA} enables to
}
\note{
Original \code{cancerType.clin.merged.txt} file will be changed after performing merge operation.

Only one of \code{rnaseqDir} and \code{mutationDir} can be used at a time.
}
\seealso{
Other RTCGA.tools: \code{\link{calculate_cooccurence}};
  \code{\link{clinicalStageSurvival}};
  \code{\link{mergeStages}}
}

