% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TP53_variants.R
\name{calculate_cooccurence}
\alias{calculate_cooccurence}
\title{Calculates coocurence matrix for given tumor}
\usage{

  calculate_cooccurence(path = "gdac.broadinstitute.org_BRCA.Mutation_Packager_Calls.Level_3.2015020400.0.0/",
  gene = "TP53", position = "amino_acid_change_WU", onlyMissense = TRUE,
  minCount = 5)
}
\arguments{
\item{path}{path to the folder with MAF files}

\item{gene}{name of gene}

\item{position}{name of collumn with position of mutation}

\item{onlyMissense}{should mutations be limited only to missense}

\item{minCount}{only positions with counts greater or equal will be retured}
}
\value{
A cooccurence matrix.
}
\description{
First you need to download MAF files from TCGA Mutation_Packager_Calls.
The format is: mutations for one patient are stored in one MAF file.
This functions read data from all MAF files, filter out only patients with mutations in gene 'gene'.
For given gene calculates cooccurence of mutations in different genes and poistions of mutations in gene 'gene'.
}
\examples{
\dontrun{
calculate_cooccurence()
}
}
\seealso{
Other RTCGA.tools: \code{\link{clinicalStageSurvival}};
  \code{\link{mergeStages}}; \code{\link{mergeTCGA}}
}

