## RTCGA package for R
#' @title The Caner Genome Atlas data integration
#'
#' @description
#' The Cancer Genome Atlas (TCGA) Data Portal provides a platform for researchers to search, download, and analyze data sets generated by TCGA. It contains clinical information, genomic characterization data, and high level sequence analysis of the tumor genomes. The key is to understand genomics to improve cancer care. RTCGA package offers download and integration of the variety and volume of TCGA data using patient barcode key, what enables easier data possession. This may have an benefcial infuence on impact on development of science and improvement of patients' treatment. Furthermore, RTCGA package transforms TCGA data to form which is convenient to use in R statistical package. Those data transformations can be a part of statistical analysis pipeline which can be more reproducible with RTCGA
#'
#' @section Issues:
#' 
#' If you have any problems, issues or think that something is missing or is not
#' clear please post an issue on 
#' \href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
#'
#' @author
#' Marcin Kosinski [aut, cre] \email{ m.p.kosinski@@gmail.com } \cr
#' Przemyslaw Biecek [aut] \email{ przemyslaw.biecek@@gmail.com } \cr
#' Witold Chodor [ctb] \email{witoldchodor@@gmail.com}
#' 
#' @seealso 
#' 
#' \pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA}{http://rtcga.github.io/RTCGA}.
#' 
#' @importFrom xml2 read_html
#' @importFrom rvest html_nodes html_attr html_text
#' @import knitr
#' @import dplyr
#' @importFrom data.table fread
#' @importFrom stringi stri_extract_all_regex
#' @importFrom assertthat assert_that
#' @importFrom XML readHTMLTable
#' @import survminer
#' @import survival
#' @importFrom viridis scale_fill_viridis
#' @importFrom scales comma
#' @importFrom ggthemes scale_colour_tableau scale_fill_tableau theme_pander
#' @importFrom utils download.file read.delim setTxtProgressBar tail txtProgressBar untar write.table 
#' @import ggplot2
#' @importFrom htmltools tagList
#' @importFrom rmarkdown html_dependency_font_awesome
#' @importFrom purrr map_if
#' @importFrom stats as.formula na.omit prcomp predict qchisq reformulate setNames
#' @importFrom RCurl getURL
#' @examples
#' \dontrun{
#' browseVignettes('RTCGA')
#' }
#' @family RTCGA
#' @name RTCGA-package
#' @docType package
#' @aliases RTCGA
invisible(NULL)

