# Robust Probabilistic Averaging (RPA)

[Robust Probabilistic Averaging
(RPA)](http://bioconductor.org/packages/release/bioc/html/RPA.html) is
a fully scalable algorithm for probe-level preprocessing and analysis
of short oligonucleotide gene expression microarray collections of any
size, from moderately sized standard data sets to arbitrarily large
microarray atlases involving tens of thousands of samples, or more.
RPA also provides explicit data-driven estimates of probe-specific
affinity and noise based on a rigorous probabilistic model and
significantly outperforms the standard RMA model in benchmarking tests
([NAR 2013](http://nar.oxfordjournals.org/content/41/10/e110)), at the
same time achieving a full scalability.


## How to use

The method is available in
[R/Bioconductor](http://bioconductor.org/packages/devel/bioc/html/RPA.html),
and documented in the publications listed below. For all installation
and usage instructions, kindly see the [RPA
wiki](https://github.com/antagomir/RPA/wiki).


## Citing RPA

The RPA methodology has been documented in these two
publications. Kindly cite if appropriate:

 * [A fully scalable online pre-processing algorithm for short oligonucleotide microarray atlases](http://nar.oxfordjournals.org/content/41/10/e110) Leo Lahti, Aurora Torrente, Laura L Elo, Alvis Brazma, Johan Rung. _Nucleic Acids Research'_ 41(10):e110, 2013. 

 * [Probabilistic analysis of probe reliability in differential gene expression studies with short oligonucleotide arrays](https://www.researchgate.net/publication/224439493_Probabilistic_Analysis_of_Probe_Reliability_in_Differential_Gene_Expression_Studies_with_Short_Oligonucleotide_Arrays/file/9fcfd4fbe8b3e5387a.pdf) Leo Lahti, Laura L. Elo, Tero Aittokallio, and Samuel Kaski. _IEEE/ACM Transactions on Computational Biology and Bioinformatics_ 8(1):217-25, 2011. 

