% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa.online.R
\name{rpa.online}
\alias{rpa.online}
\title{rpa.online}
\usage{
rpa.online(
  cel.path = NULL,
  cel.files = NULL,
  sets = NULL,
  cdf = NULL,
  bg.method = "rma",
  probe.parameters = list(alpha = 1, beta = 1),
  epsilon = 0.01,
  mc.cores = 1,
  verbose = TRUE,
  shuffle = TRUE,
  batch.size = 100,
  batches = NULL,
  save.batches.dir = ".",
  keep.batch.files = FALSE,
  unique.run.identifier = paste("RPA-run-id-", rnorm(1), sep = ""),
  rseed = 23,
  speedup = TRUE,
  summarize.with.affinities = FALSE
)
}
\arguments{
\item{cel.path}{Path to CEL file directory}

\item{cel.files}{List of CEL files to preprocess}

\item{sets}{Probesets for which RPA will be computed}

\item{cdf}{Specify an alternative CDF environment}

\item{bg.method}{Specify background correction method. See bgcorrect.methods() for options.}

\item{probe.parameters}{Can be used to set user-specified priors for the model parameters alpha, beta. Not used tau2.method = "var". The prior parameters alpha and beta are prior parameters for inverse Gamma distribution of probe-specific variances. Noninformative prior is obtained with alpha, beta -> 0.  Not used with tau2.method 'var'. Scalar alpha and beta specify an identical inverse Gamma prior for all probes, which regularizes the solution. Can be also specified as lists, each element corresponding to one probeset. May also include quantile.basis, which should be provided at log2 domain.}

\item{epsilon}{Convergence tolerance. The iteration is deemed converged when the change in all parameters is < epsilon.}

\item{mc.cores}{Number of cores for parallel computation}

\item{verbose}{Print progress information during computation}

\item{shuffle}{Form random batches}

\item{batch.size}{Batch size for online mode (rpa.online); the complete list of CEL files will be preprocessed in batches with this size using Bayesian online-updates for probe-specific parameters.}

\item{batches}{User-defined CEL file batches}

\item{save.batches.dir}{Output directory for temporary batch saves.}

\item{keep.batch.files}{Logical. Keep (TRUE) or remove (FALSE) the batch files after preprocessing.}

\item{unique.run.identifier}{Define identifier for this run for naming the temporary batch files. By default, a random id is generated.}

\item{rseed}{Random seed.}

\item{speedup}{Speed up computations with approximations.}

\item{summarize.with.affinities}{Use affinity estimates in probe summarization step. Default: FALSE.}
}
\value{
List with two elements: an instance of the 'expressionSet' class and probe parameters. For probe.parameters contents, see the probe.parameters input argument.
}
\description{
RPA-online for preprocessing very large expression data sets.
}
\details{
rpa.online is used to preprocess very large expression data collections based on a Bayesian hyperparameter update procedure. Returns an expressionSet object preprocessed with RPA. Gives an estimate of the probeset-level mean parameter d of the RPA model, and returns these in an expressionSet object. The CEL files are handled in batches to obtain Bayesian updates for probe-specific hyperpriors; after sweeping through the database in batches the results are combined. The online mode is useful for preprocessing very large expression data sets where ordinary preprocessing algorithms fail, without compromises in modelling stage.
}
\examples{
# eset <- rpa.online(cel.file.path) 
}
\references{
See citation("RPA")
}
\seealso{
rpa, AffyBatch, ExpressionSet
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{methods}
