% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa.fit.R
\name{rpa.fit}
\alias{rpa.fit}
\title{RPA fit}
\usage{
rpa.fit(
  dat,
  epsilon = 0.01,
  alpha = NULL,
  beta = NULL,
  tau2.method = "robust",
  d.method = "fast",
  summarize.with.affinities = FALSE
)
}
\arguments{
\item{dat}{Original data: probes x samples.}

\item{epsilon}{Convergence tolerance. The iteration is deemed converged when the change in all parameters is < epsilon.}

\item{alpha}{alpha prior for inverse Gamma distribution of probe-specific variances. Noninformative prior is obtained with alpha, beta -> 0. Not used with tau2.method 'var'. Scalar alpha and beta are specify equal inverse Gamma prior for all probes to regularize the solution. The defaults depend on the method.}

\item{beta}{beta prior for inverse Gamma distribution of probe-specific variances. Noninformative prior is obtained with alpha, beta -> 0. Not used with tau2.method 'var'. Scalar alpha and beta are specify equal inverse Gamma prior for all probes to regularize the solution. The defaults depend on the method.}

\item{tau2.method}{Optimization method for tau2 (probe-specific variances);

"robust": (default) update tau2 by posterior mean,
    regularized by informative priors that are identical
    for all probes (user-specified by
    setting scalar values for alpha, beta). This
    regularizes the solution, and avoids overfitting where
    a single probe obtains infinite reliability. This is a
    potential problem in the other tau2 update
    methods with non-informative variance priors. The
    default values alpha = 2; beta = 1 are
    used if alpha and beta are not specified.

     "mode": update tau2 with posterior mean

"mean": update tau2 with posterior mean

"var": update tau2 with variance around d. Applies the fact
     that tau2 cost function converges to variance with
       large sample sizes.}

\item{d.method}{Method used to optimize d. Options:

 "fast": (default) weighted mean over the probes, weighted
 by probe variances The solution converges to this with
large sample size.

 "basic": optimization scheme to find a mode used in Lahti
 et al. TCBB/IEEE; relatively slow; preferred with small
sample size.}

\item{summarize.with.affinities}{Use affinity estimates in probe summarization step. Default: FALSE.}
}
\value{
mu: Fitted signal in original data: mu.real + d; mu.real: Shifting parameter of the reference sample; tau2: Probe-specific stochastic noise; affinity: Probe-specific affinities; data: Probeset data matrix; alpha, beta: prior parameters
}
\description{
Fit the RPA model.
}
\details{
Fits the RPA model, including estimation of probe-specific affinity parameters. First learns a point estimate for the RPA model in terms of differential expression values w.r.t. reference sample. After this, probe affinities are estimated by comparing original data and differential expression shape, and setting prior assumptions concerning probe affinities.
}
\examples{
# res <- rpa.fit(dat, epsilon, alpha, beta, tau2.method, d.method, affinity.method)
}
\references{
See citation("RPA")
}
\seealso{
rpa, estimate.affinities
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
