% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gene_bin_intervals.R
\name{get_gene_bin_intervals}
\alias{get_gene_bin_intervals}
\title{get_gene_bin_intervals}
\usage{
get_gene_bin_intervals(DGE, data, n = 10)
}
\arguments{
\item{DGE}{A DGEList object.}

\item{data}{Sample data with one row per sample. Sample row order should match the col order in the DGEList.}

\item{n}{Genes per bin are set so that each bin has approximately 1 gene per n individuals in the data.}
}
\value{
Data frame with one row per gene bin. Columns indicate the start and end positions and the number of genes of each bin.
}
\description{
Creates gene bins. Input DGE list, sample data,
and 'n' number of individuals per genes. By default, number of bins and
genes per bin are set so that each bin has approximately 1 gene per
10 individuals in the data.
}
\examples{
data(example_data)
data(example_DGE)
intervals <- get_gene_bin_intervals(example_DGE, example_data, n = 10)
gene_bin_impute <- impute_by_gene_bin(example_data,
    intervals,
    example_DGE,
    m = 2
)
coef_se <- limmavoom_imputed_data_list(
    gene_intervals = intervals,
    DGE = example_DGE,
    imputed_data_list = gene_bin_impute,
    m = 2,
    voom_formula = "~x + y + z + a + b"
)

final_res <- combine_rubins(
    DGE = example_DGE,
    model_results = coef_se,
    predictor = "x"
)
}
