% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAsense.R
\name{combineResults}
\alias{combineResults}
\title{Combine results}
\usage{
combineResults(myresultSwitch = resultSwitch, myresultFC = resultFC,
  nrcores = 1)
}
\arguments{
\item{myresultSwitch}{data.frame, output of \link{getSwitch}}

\item{myresultFC}{data.frame, output of \link{getFC}}

\item{nrcores}{Numeric, Number of cores for parallelization, default 1 for no parallelization}
}
\value{
Data.frame containing information on switch and fold change detection for each gene
}
\description{
Results of switch and fold change analysis are collected in one data.frame
}
\examples{
data(MZsox)
mydata <- MZsox[seq(1,nrow(MZsox), by=10),]
resultFC <- getFC(dataset = mydata,
myanalyzeConditions = c("WT", "MZsox"),
cores = 1,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6))
resultSwitch <- getSwitch(dataset = mydata,
experimentStepDetection = "WT",
cores = 1,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6))
combineResults(resultSwitch, resultFC)
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
