% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modifier-subset.R,
%   R/SequenceData-subset.R
\name{subsetByCoord}
\alias{subsetByCoord}
\alias{labelByCoord}
\alias{subsetByCoord,Modifier,GRanges-method}
\alias{subsetByCoord,Modifier,GRangesList-method}
\alias{subset,ModifierSet-method}
\alias{subsetByCoord,ModifierSet,GRanges-method}
\alias{subsetByCoord,ModifierSet,GRangesList-method}
\alias{labelByCoord,Modifier,GRanges-method}
\alias{labelByCoord,Modifier,GRangesList-method}
\alias{labelByCoord,ModifierSet,GRanges-method}
\alias{labelByCoord,ModifierSet,GRangesList-method}
\alias{subsetByCoord,SplitDataFrameList,GRanges-method}
\alias{subset,SequenceData-method}
\alias{subsetByCoord,SequenceData,GRanges-method}
\alias{subsetByCoord,SequenceData,GRangesList-method}
\alias{subset,SequenceDataSet-method}
\alias{subsetByCoord,SequenceDataSet,GRanges-method}
\alias{subsetByCoord,SequenceDataSet,GRangesList-method}
\alias{subset,SequenceDataList-method}
\alias{subsetByCoord,SequenceDataList,GRanges-method}
\alias{subsetByCoord,SequenceDataList,GRangesList-method}
\alias{labelByCoord,SequenceData,GRanges-method}
\alias{labelByCoord,SequenceData,GRangesList-method}
\alias{labelByCoord,SequenceDataSet,GRanges-method}
\alias{labelByCoord,SequenceDataSet,GRangesList-method}
\alias{labelByCoord,SequenceDataList,GRanges-method}
\alias{labelByCoord,SequenceDataList,GRangesList-method}
\title{Subsetting data from a \code{SequenceData}, \code{SequenceDataSet},
\code{SequenceDataList}, \code{Modifier} or \code{ModifierSet} object.}
\usage{
subsetByCoord(x, coord, ...)

labelByCoord(x, coord, ...)

\S4method{subsetByCoord}{Modifier,GRanges}(x, coord, ...)

\S4method{subsetByCoord}{Modifier,GRangesList}(x, coord, ...)

\S4method{subset}{ModifierSet}(x, name, pos = 1L, ...)

\S4method{subsetByCoord}{ModifierSet,GRanges}(x, coord, ...)

\S4method{subsetByCoord}{ModifierSet,GRangesList}(x, coord, ...)

\S4method{labelByCoord}{Modifier,GRanges}(x, coord, ...)

\S4method{labelByCoord}{Modifier,GRangesList}(x, coord, ...)

\S4method{labelByCoord}{ModifierSet,GRanges}(x, coord, ...)

\S4method{labelByCoord}{ModifierSet,GRangesList}(x, coord, ...)

\S4method{subsetByCoord}{SplitDataFrameList,GRanges}(x, coord, ...)

\S4method{subset}{SequenceData}(x, name, pos = 1L, ...)

\S4method{subsetByCoord}{SequenceData,GRanges}(x, coord, ...)

\S4method{subsetByCoord}{SequenceData,GRangesList}(x, coord, ...)

\S4method{subset}{SequenceDataSet}(x, name, pos = 1L, ...)

\S4method{subsetByCoord}{SequenceDataSet,GRanges}(x, coord, ...)

\S4method{subsetByCoord}{SequenceDataSet,GRangesList}(x, coord, ...)

\S4method{subset}{SequenceDataList}(x, name, pos = 1L, ...)

\S4method{subsetByCoord}{SequenceDataList,GRanges}(x, coord, ...)

\S4method{subsetByCoord}{SequenceDataList,GRangesList}(x, coord, ...)

\S4method{labelByCoord}{SequenceData,GRanges}(x, coord, ...)

\S4method{labelByCoord}{SequenceData,GRangesList}(x, coord, ...)

\S4method{labelByCoord}{SequenceDataSet,GRanges}(x, coord, ...)

\S4method{labelByCoord}{SequenceDataSet,GRangesList}(x, coord, ...)

\S4method{labelByCoord}{SequenceDataList,GRanges}(x, coord, ...)

\S4method{labelByCoord}{SequenceDataList,GRangesList}(x, coord, ...)
}
\arguments{
\item{x}{a \code{SequenceData}, \code{SequenceDataSet},
\code{SequenceDataList}, \code{Modifier} or \code{ModifierSet} object.}

\item{coord}{coordinates of position to subset to. Either a \code{GRanges} or
a \code{GRangesList} object. For both types the 'Parent' column is expected to
match the transcript name.}

\item{...}{Optional parameters:
\itemize{
\item \code{type}: the modification type used for subsetting. By default 
this is derived from the \code{modType(x)}, but it can be overwritten using 
\code{type}. It must be a valid shortName for a modification according to
\code{shortName(ModRNAString())} or \code{shortName(ModDNAString())} 
(depending on the type of Modifier class) and of course be present in 
metadata column \code{mod} of \code{coord}. To disable subsetting based on 
type, set \code{type = NA}.
\item \code{flanking}: a single integer value to select how many flanking
position should be included in the subset (default: \code{flanking = 0L}).
\item \code{merge}: \code{TRUE} or \code{FALSE}: Should the 
overlapping selections be merged? This is particular important, if flanking
value \code{!= 0L} are set. (default: \code{merge = TRUE}).
\item \code{perTranscript}: \code{TRUE} or \code{FALSE}: Should the 
positions labeled per transcript and not per chromosome?
(default: \code{perTranscript = FALSE}).
}}

\item{name}{Optional: Limit results to one specific transcript.}

\item{pos}{Optional: Limit results to a specific position.}
}
\value{
If 'x' is a
\itemize{
\item \code{\link[=SequenceData-class]{SequenceData}} or 
\code{\link[=Modifier-class]{Modifier}}: a \code{SplitDataFrameList}
with elments per transcript.
\item \code{\link[=SequenceDataSet-class]{SequenceDataSet}},
\code{\link[=SequenceDataList-class]{SequenceDataList}} or
\code{\link[=ModifierSet-class]{ModifierSet}}: a \code{SimpleList} of
\code{SplitDataFrameList} with elments per transcript.
}
}
\description{
With the \code{subsetByCoord} function data from a \code{SequenceData},
\code{SequenceDataSet}, \code{SequenceDataList}, \code{Modifier} or
\code{ModifierSet} object can be subset to positions as defined in
\code{coord}.

If \code{coord} contains a column \code{mod} and \code{x} is a
\code{Modifier} object, it will be filtered to identifiers matching the
\code{\link[=Modifier-functions]{modType}} of \code{x}. To disable this
behaviour remove the column \code{mod} from \code{coord} or set \code{type =
NA}

\code{labelByCoord} functions similarly. It will return a
\code{SplitDataFrameList}, which matches the dimensions of the aggregated
data plus the \code{labels} column, which contains logical values to indicate
selected positions.
}
\examples{
data(msi,package="RNAmodR")
mod <- modifications(msi)
coord <- unique(unlist(mod))
coord$score <- NULL
coord$sd <- NULL
subsetByCoord(msi,coord)
}
