% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceDataList-class.R
\docType{class}
\name{SequenceDataList-class}
\alias{SequenceDataList-class}
\alias{SequenceDataList}
\title{The SequenceDataList class}
\usage{
SequenceDataList(...)
}
\arguments{
\item{...}{The elements to be included in the \code{SequenceDataList}.}
}
\value{
a \code{SequenceDataList}
}
\description{
The \code{SequenceDataList} class is used to hold \code{SequenceData} or 
\code{SequenceDataSet} objects as its elements. It is derived from the 
\code{\link[S4Vectors:List-class]{List}} class.

The \code{SequenceDataList} is used to hold data from different sets of
aligned reads. This allows multiple methods to be aggregated into one
modification detection strategy. Annotation and sequence data must be the 
same for all elements, however the bam files can be different.
}
\examples{
data(psd,package="RNAmodR")
data(e5sd,package="RNAmodR")
sdl <- SequenceDataList(SequenceDataSet(psd,e5sd),e5sd)
}
