% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modifier-class.R,
%   R/ModifierSet-class.R
\name{Modifier-functions}
\alias{Modifier-functions}
\alias{bamfiles}
\alias{mainScore}
\alias{modifierType}
\alias{modType}
\alias{dataType}
\alias{sequenceData}
\alias{sequences}
\alias{validAggregate}
\alias{validModification}
\alias{show,Modifier-method}
\alias{bamfiles,Modifier-method}
\alias{conditions,Modifier-method}
\alias{mainScore,Modifier-method}
\alias{modifierType,Modifier-method}
\alias{modType,Modifier-method}
\alias{dataType,Modifier-method}
\alias{names,Modifier-method}
\alias{ranges,Modifier-method}
\alias{replicates,Modifier-method}
\alias{seqinfo,Modifier-method}
\alias{seqtype,Modifier-method}
\alias{sequenceData,Modifier-method}
\alias{sequences,Modifier-method}
\alias{validAggregate,Modifier-method}
\alias{validModification,Modifier-method}
\alias{show,ModifierSet-method}
\alias{bamfiles,ModifierSet-method}
\alias{conditions,ModifierSet-method}
\alias{mainScore,ModifierSet-method}
\alias{modifications,ModifierSet-method}
\alias{modifierType,ModifierSet-method}
\alias{modType,ModifierSet-method}
\alias{dataType,ModifierSet-method}
\alias{ranges,ModifierSet-method}
\alias{replicates,ModifierSet-method}
\alias{seqinfo,ModifierSet-method}
\alias{seqtype,ModifierSet-method}
\alias{sequences,ModifierSet-method}
\title{Modifier/ModifierSet functions}
\usage{
bamfiles(x)

mainScore(x)

modifierType(x)

modType(x)

dataType(x)

sequenceData(x)

sequences(x, ...)

validAggregate(x)

validModification(x)

\S4method{show}{Modifier}(object)

\S4method{bamfiles}{Modifier}(x)

\S4method{conditions}{Modifier}(object)

\S4method{mainScore}{Modifier}(x)

\S4method{modifierType}{Modifier}(x)

\S4method{modType}{Modifier}(x)

\S4method{dataType}{Modifier}(x)

\S4method{names}{Modifier}(x)

\S4method{ranges}{Modifier}(x)

\S4method{replicates}{Modifier}(x)

\S4method{seqinfo}{Modifier}(x)

\S4method{seqtype}{Modifier}(x)

\S4method{sequenceData}{Modifier}(x)

\S4method{sequences}{Modifier}(x, modified = FALSE)

\S4method{validAggregate}{Modifier}(x)

\S4method{validModification}{Modifier}(x)

\S4method{show}{ModifierSet}(object)

\S4method{bamfiles}{ModifierSet}(x)

\S4method{conditions}{ModifierSet}(object)

\S4method{mainScore}{ModifierSet}(x)

\S4method{modifications}{ModifierSet}(x, perTranscript = FALSE)

\S4method{modifierType}{ModifierSet}(x)

\S4method{modType}{ModifierSet}(x)

\S4method{dataType}{ModifierSet}(x)

\S4method{ranges}{ModifierSet}(x)

\S4method{replicates}{ModifierSet}(x)

\S4method{seqinfo}{ModifierSet}(x)

\S4method{seqtype}{ModifierSet}(x)

\S4method{sequences}{ModifierSet}(x, modified = FALSE)
}
\arguments{
\item{x, object}{a \code{Modifier} or \code{ModifierSet} class}

\item{...}{Additional arguments.}

\item{modified}{For \code{sequences}: \code{TRUE} or \code{FALSE}: Should
the sequences be returned as a \code{ModRNAString}/\code{ModDNAString} with
the found modifications added on top of the \code{RNAString}/
\code{DNAString}? See 
\code{\link[Modstrings:separate]{combineIntoModstrings}}.}

\item{perTranscript}{\code{TRUE} or \code{FALSE}: Should the positions shown
per transcript? (default: \code{perTranscript = FALSE})}
}
\value{
\itemize{
\item \code{modifierType}: a character vector with the appropriate class
Name of a \code{\link[=Modifier-class]{Modifier}}.
\item \code{modType}: a character vector with the modifications detected by
the \code{Modifier} class.
\item \code{seqtype}: a single character value defining if either
"RNA" or "DNA" modifications are detected by the \code{Modifier} class.
\item \code{mainScore}: a character vector.
\item \code{sequenceData}: a \code{SequenceData} object.
\item \code{modifications}: a \code{GRanges} or \code{GRangesList} object
describing the found modifications.
\item \code{seqinfo}: a \code{Seqinfo} object.
\item \code{sequences}: a \code{RNAStingSet} object.
\item \code{ranges}: a \code{GRangesList} object with each element per
transcript.
\item \code{bamfiles}: a \code{BamFileList} object.
\item \code{validAggregate}: \code{TRUE} or \code{FALSE}. Checks if current
settings are the same for which the data was aggregate
\item \code{validModification}: \code{TRUE} or \code{FALSE}. Checks if 
current settings are the same for which modification were found
}
}
\description{
For the \code{Modifier} and  \code{ModifierSet} classes a number of functions
are implemented to access the data stored by the object.

The \code{validAggregate} and \code{validModification} functions check if
\code{\link[=settings]{settings}} have been modified, after the data was 
loaded. This potentially invalidates them. To update the data, run the
\code{aggregate} or the \code{modify} function.
}
\examples{
data(msi,package="RNAmodR")
mi <- msi[[1]]
modifierType(mi) # The class name of the Modifier object
modifierType(msi)
seqtype(mi)
modType(mi)
mainScore(mi)
sequenceData(mi)
modifications(mi)
# general accessors
seqinfo(mi)
sequences(mi)
ranges(mi)
bamfiles(mi)
}
\seealso{
\code{\link[=settings]{settings}}
}
