% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modifier-class.R
\docType{class}
\name{Modifier-class}
\alias{Modifier-class}
\alias{Modifier}
\alias{Modifier,SequenceData-method}
\alias{Modifier,SequenceDataSet-method}
\alias{Modifier,SequenceDataList-method}
\alias{Modifier,character-method}
\alias{Modifier,list-method}
\alias{Modifier,BamFileList-method}
\alias{RNAModifier-class}
\alias{DNAModifier-class}
\title{The Modifier class}
\usage{
Modifier(className, x, annotation, sequences, seqinfo, ...)

\S4method{Modifier}{SequenceData}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{Modifier}{SequenceDataSet}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{Modifier}{SequenceDataList}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{Modifier}{character}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{Modifier}{list}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{Modifier}{BamFileList}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)
}
\arguments{
\item{className}{The name of the class which should be constructed.}

\item{x}{the input which can be of the following types
\itemize{
\item \code{SequenceData}: a single \code{SequenceData} or a list
containing only \code{SequenceData} objects. The input will just be used to
file the \code{data} slot of the \code{Modifier} and must match the
requirements of specific \code{Modifier} class.
\item \code{BamFileList}: a named \code{BamFileList}
\item \code{character}: a \code{character} vector, which must be coercible
to a named \code{BamFileList} referencing existing bam files. Valid names are
\code{control} and \code{treated} to define conditions and replicates
}}

\item{annotation}{annotation data, which must match the information contained
in the BAM files. This parameter is only required if \code{x} is not a
\code{SequenceData} object or a list of \code{SequenceData} objects.}

\item{sequences}{sequences matching the target sequences the reads were
mapped onto. This must match the information contained in the BAM files.
TThis parameter is only required if \code{x} is not a \code{SequenceData}
object or a list of \code{SequenceData} objects.}

\item{seqinfo}{An optional \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}}
argument or character vector, which can be coerced to one, to subset the
sequences to be analyzed on a per chromosome basis.}

\item{...}{Additional otpional parameters:
\itemize{
\item \code{find.mod}: \code{TRUE} or \code{FALSE}: should the search for
for modifications be triggered upon construction? If not the search can be
started by calling the \code{modify()} function.
\item additional parameters depending on the specific \code{Modifier} class
}
All additional options must be named and will be passed to the
\code{\link[=settings]{settings}} function and onto the \code{SequenceData}
objects, if \code{x} is not a \code{SequenceData} object or a list of
\code{SequenceData} objects.}
}
\value{
a \code{Modifier} object of type \code{className}
}
\description{
The \code{Modifier} class is a virtual class, which provides the central
functionality to search for post-transcriptional RNA modification patterns in
high throughput sequencing data.

Each subclass has to implement the following functions:

\itemize{
\item Slot \code{nucleotide}: Either "RNA" or "DNA". For conveniance the
subclasses \code{RNAModifier} and \code{DNAModifier} are already available
and can be inherited from.
\item Function \code{\link{aggregateData}}: used for specific data 
aggregation
\item Function \code{\link{findMod}}: used for specific search for 
modifications
}

Optionally the function \code{\link[=Modifier-functions]{settings<-}} can be
implemented to store additional arguments, which the base class does not
recognize.

\code{Modifier} objects are constructed centrally by calling
\code{Modifier()} with a \code{className} matching the specific class to be
constructed. This will trigger the immediate analysis, if \code{find.mod} is
not set to \code{FALSE}.
}
\section{Slots}{

\describe{
\item{\code{nucleotide}}{a \code{character} value, which needs to contain "RNA" or 
"DNA"}

\item{\code{mod}}{a \code{character} value, which needs to contain one or more
elements from the alphabet of a
\code{\link[Modstrings:ModRNAString]{ModRNAString}} or 
\code{\link[Modstrings:ModDNAString]{ModDNAString}} class.}

\item{\code{score}}{the main score identifier used for visualizations}

\item{\code{dataType}}{the class name(s) of the \code{SequenceData} class used}

\item{\code{bamfiles}}{the input bam files as \code{BamFileList}}

\item{\code{condition}}{conditions along the \code{BamFileList}: Either
\code{control} or \code{treated}}

\item{\code{replicate}}{replicate number along the \code{BamFileList} for each of the
condition types.}

\item{\code{data}}{The sequence data object: Either a \code{SequenceData},
\code{SequenceDataSet} or a \code{SequenceDataList} object, if more than one
\code{dataType} is used.}

\item{\code{aggregate}}{the aggregated data as a \code{SplitDataFrameList}}

\item{\code{modifications}}{the found modifications as a \code{GRanges} object}

\item{\code{settings}}{arguments used for the analysis as a \code{list}}

\item{\code{aggregateValidForCurrentArguments}}{\code{TRUE} or \code{FALSE} whether
the aggregate data was constructed with the current arguments}

\item{\code{modificationsValidForCurrentArguments}}{\code{TRUE} or \code{FALSE}
whether the modifications were found with the current arguments}
}}

\section{Creation}{

\code{Modifier} objects can be created in two ways, either by providing a
list of bamfiles or
\code{SequenceData}/\code{SequenceDataSet}/\code{SequenceDataList} objects,
which match the structure in \code{dataType()}.

\code{dataType()} can be a \code{character} vector or a \code{list} of
\code{character} vectors and depending on this the input files have to
follow this structure:

\itemize{
\item a single \code{character}: a \code{SequenceData} is
constructed/expected.
\item a \code{character} vector: a \code{SequenceDataSet} is
constructed/expected.
\item a \code{list} of \code{character} vectors: a \code{SequenceDataList}
is constructed/expected.
}

The cases for a \code{SequenceData} or \code{SequenceDataSet} are straight
forward, since the input remains the same. The last case is special, since it
is a hypothetical option, in which bam files from two or more different
methods have to be combined to reliably detect a single modification (The
elements of a \code{SequenceDataList} don't have to be created from the
bamfiles, whereas from a \code{SequenceDataSet} they have to be).

For this example a \code{list} of \code{character} vectors is expected.
Each element must be named according to the names of \code{dataType()} and
contain a \code{character} vector for creating a \code{SequenceData} object.

All additional options must be named and will be passed to the
\code{\link[=settings]{settings}} function and onto the \code{SequenceData}
objects, if \code{x} is not a \code{SequenceData} object or a list of
\code{SequenceData} objects.
}

