% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sse.R
\name{sse_null_decaying_decay}
\alias{sse_null_decaying_decay}
\alias{sse_null_const_decay}
\title{sum of the squared errors for null models}
\usage{
sse_null_decaying_decay(a, b, m, t)

sse_null_const_decay(a, m, t)
}
\arguments{
\item{a}{alpha value}

\item{b}{beta value}

\item{m}{mRNA abundance values}

\item{t}{time points of \code{m}}
}
\value{
Returns the sum of the squared errors
}
\description{
For a model that uses a constant decay rate or a decaying decay rate, calculates the sum of the squared errors (differences between the supplied data points and the modeled values based on alpha and/or beta values). For these models all treatments are assumed to have the same \code{a} (alpha) and/or \code{b} (beta).
}
\examples{
sse_null_decaying_decay(a=0.05, b = 0.001,
           m = c(1,1,1,0.99,0.5,0.5,0.5,0.49,0.25,0.25,0.25,0.24,0.12,0.125,0.125,0.126),
           t = rep(c(0,10,20,30),each = 4))
sse_null_const_decay(a=0.05,
           m = c(1,1,1,0.99,0.5,0.5,0.5,0.49,0.25,0.25,0.25,0.24,0.12,0.125,0.125,0.126),
           t = rep(c(0,10,20,30),each = 4))
}
\keyword{internal}
