% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hl_plot.R
\name{hl_plot}
\alias{hl_plot}
\title{hl_plot() function}
\usage{
hl_plot(
  geneID,
  gene_symbol = "",
  df_decay_rates,
  hl_dist_treatment,
  hl_treatment,
  arrow_colors = NA,
  arrow_lab_loc = c("key"),
  x_limits = log(2)/c(0.25, 0.00045),
  x_breaks = c(5, 1:12 * 10, 180, 240, 300, 360, 420, 480, 720, 1080, 1440),
  x_tick_labels = c("5", "10", "", "30", "", "", "60", "", "", "", "", "", "2h", "",
    "4h", "", "", "", "8h", "12h", "", "24h")
)
}
\arguments{
\item{geneID}{single gene ID from data set (e.g. "AT3G14100") for which to plot data/model}

\item{gene_symbol}{(optional) pasted to gene ID in plot label (e.g., "AT3G14100/UBP1C)}

\item{df_decay_rates}{data.frame of modeling results with decay rate columns labeled as alpha_<treatment>}

\item{hl_dist_treatment}{name of the treatment for which the background distribution will be plotted}

\item{hl_treatment}{names of the treatments for which arrows indicating half-life will be plotted}

\item{arrow_colors}{(optional) character vector of R colors; named with corresponding treatments}

\item{arrow_lab_loc}{label arrows on plot ("plot") or in a key ("key")}

\item{x_limits}{x-axis (half-life) limits in min; default is log(2)/c(0.25,4.5e-4)}

\item{x_breaks}{x-axis (half-life) breaks/tick marks in min defaults to c(5,1:12*10,180,240,300,360,420,480,720,1080,1440)}

\item{x_tick_labels}{x-axis (half-life) break labels, defaults to c("5","10","","30","","","60","","","","","","2h","","4h","","","","8h","12h","","24h")+}
}
\value{
returns a ggplot to be used with print; could also be modified using the syntax of ggplot2 e.g.'+geom_XXXX(...)'
}
\description{
Plots RNA half-life distribution with select half-lives of select RNAs as large arrows colored by treatment using the ggplot2 package.
}
\examples{

p <- hl_plot(
geneID = rownames(RNAdecay::results)[4],
df_decay_rates = RNAdecay::results,
hl_treatment = c("WT","sov","vcs","vcs.sov"),
hl_dist_treatment = "WT",
arrow_colors = c(WT = "#88CCEE", sov = "#CC6677", vcs = "#117733",vcs.sov = "#882255"),
arrow_lab_loc = "key",
gene_symbol = ""
)

print(p)

p <- hl_plot(
geneID = rownames(RNAdecay::results)[4],
gene_symbol = "",
df_decay_rates = RNAdecay::results,
hl_dist_treatment = "WT",
hl_treatment = c("WT","sov","vcs","vcs.sov"),
arrow_colors = c(WT = "#88CCEE", sov = "#CC6677", vcs = "#117733",vcs.sov = "#882255"),
arrow_lab_loc = "plot"
)

print(p)
}
