% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.R
\name{makeplot}
\alias{makeplot}
\title{Make plot to visualize RNA age}
\usage{
makeplot(
  res,
  main = "RNA age vs chronological age",
  xlab = "chronological age",
  ylab = "RNA Age"
)
}
\arguments{
\item{res}{a data frame returned by `predict_age` function. If the
chronological age is not provided when using `predict_age` function,
visulization cannot be made.}

\item{main}{title of the plot}

\item{xlab}{label of x-axis}

\item{ylab}{label of y-axis}
}
\value{
the plot which shows RNA age vs chronological age
}
\description{
This function makes plots to visualize the relationship
between chronological age and RNA age.
}
\examples{
data(fpkmExample)
fpkm_large = cbind(fpkm, fpkm, fpkm, fpkm)
fpkm_large = cbind(fpkm_large, fpkm_large, fpkm_large, fpkm_large)
colnames(fpkm_large) = paste0("sample",1:32)
chronage = data.frame(sampleid = colnames(fpkm_large), age = 1:32)
res = predict_age(exprdata = fpkm_large, exprtype = "FPKM",
chronage = chronage)
makeplot(res)
}
