% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{reanalyzeFailpeaks}
\alias{reanalyzeFailpeaks}
\alias{reanalyzeFailpeak}
\title{Reanalyze unmatched peaks}
\usage{
reanalyzeFailpeaks(w, custom_additions, filterSettings =
				getOption("RMassBank")$filterSettings, progressbar = "progressBarHook")
reanalyzeFailpeak(mass, custom_additions, cpdID, mode,
				filterSettings = getOption("RMassBank")$filterSettings)
}
\arguments{
\item{w}{A `msmsWorkspace` with annotated peaks.}

\item{custom_additions}{The allowed additions, e.g. "N2O".}

\item{filterSettings}{Settings for filtering data. Refer to\code{\link{analyzeMsMs}} for settings.}

\item{progressbar}{The progress bar callback to use. Only needed for specialized
applications.    Cf. the documentation of \code{\link{progressBarHook}} for usage.}

\item{mass}{(Usually recalibrated) m/z value of the peak.}

\item{cpdID}{Compound ID of this spectrum.}

\item{mode}{for `reanalyzeFailpeak`, the `mode` (adduct) of the analyzed spectrum.}
}
\value{
The aggregate data frame extended by the columns:
#' \item{reanalyzed.???}{If reanalysis (step 7) has already been processed: matching values from the reanalyzed peaks}
\item{matchedReanalysis}{Whether reanalysis has matched (\code{TRUE}), not matched(\code{FALSE}) or has not been conducted for the peak(\code{NA}).}

It would be good to merge the analysis functions of \code{analyzeMsMs} with
the one used here, to simplify code changes.
}
\description{
Reanalysis of peaks with no matching molecular formula by allowing
additional elements (e.g. "N2O").
}
\details{
\code{reanalyzeFailpeaks} examines the \code{unmatchedPeaksC} table in
\code{specs} and sends every peak through \code{reanalyzeFailpeak}.
}
\examples{

## As used in the workflow:
\dontrun{    
	reanalyzedRcSpecs <- reanalyzeFailpeaks(w@aggregated, custom_additions="N2O", mode="pH")
# A single peak:
reanalyzeFailpeak("N2O", 105.0447, 1234, 1, 1)
}







}
\seealso{
\code{\link{analyzeMsMs}}, \code{\link{msmsWorkflow}}
}
\author{
Michael Stravs
}
