% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{progressBarHook}
\alias{progressBarHook}
\title{Standard progress bar hook.}
\usage{
progressBarHook(object = NULL, value = 0, min = 0, max = 100, close = FALSE)
}
\arguments{
\item{object}{An identifier representing an instance of a progress bar.}

\item{value}{The new value to assign to the progress indicator}

\item{min}{The minimal value of the progress indicator}

\item{max}{The maximal value of the progress indicator}

\item{close}{If \code{TRUE}, the progress bar is closed.}
}
\value{
Returns a progress bar instance identifier (i.e. an identifier
		which can be used as \code{object} in subsequent calls.)
}
\description{
This function provides a standard implementation for the progress bar in RMassBank.
}
\details{
RMassBank calls the progress bar function in the following three ways:
\code{pb <- progressBarHook(object=NULL, value=0, min=0, max=LEN)}
to create a new progress bar.
\code{pb <- progressBarHook(object=pb, value= VAL)}
to set the progress bar to a new value (between the set \code{min} and \code{max})
\code{progressBarHook(object=pb, close=TRUE)}
to close the progress bar. (The actual calls are performed with \code{do.call}, 
e.g. 
\code{progressbar <- "progressBarHook"
pb <- do.call(progressbar, list(object=pb, value= nProg))
}. See the source code for details.)

To substitute the standard progress bar for an alternative implementation (e.g. for
use in a GUI), the developer can write his own function which behaves in the same way
as \code{progressBarHook}, i.e. takes the same parameters and can be called in the 
same way.
}
\author{
Michele Stravs, Eawag <stravsmi@eawag.ch>
}
